/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.diskquota;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.gwc.web.diskquota.JDBCConnectionPoolPanel;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geowebcache.diskquota.jdbc.JDBCConfiguration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;

public class JDBCConnectionPoolPanelTest
extends GeoServerWicketTestSupport {
    @Before
    public void setUp() {
        this.login();
    }

    @Test
    public void configPageRendersSuccessfully() {
        JDBCConfiguration.ConnectionPoolConfiguration pool = new JDBCConfiguration.ConnectionPoolConfiguration();
        pool.setDriver("org.hsqldb.jdbcDriver");
        pool.setUrl("jdbc:hsqldb:file:./target/quota-hsql");
        pool.setUsername("sa");
        pool.setPassword("actaulpassword");
        pool.setMinConnections(1);
        pool.setMaxConnections(1);
        pool.setMaxOpenPreparedStatements(50);
        Model pwModel = new Model((Serializable)pool);
        FormTestPage testPage = new FormTestPage((ComponentBuilder & Serializable)id -> new JDBCConnectionPoolPanel(id, (IModel)pwModel));
        tester.startPage((Page)testPage);
        String text = tester.getLastResponseAsString();
        MatcherAssert.assertThat((Object)text, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)pool.getPassword())));
    }
}

