/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.blob;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestHandler;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.CheckBox;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.web.blob.BlobStorePage;
import org.geoserver.gwc.web.blob.BlobStoresPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.FileBlobStoreInfo;
import org.geowebcache.layer.TileLayer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobStoresPageTest
extends GeoServerWicketTestSupport {
    private static final String ID_DUMMY1 = "zzz";
    private static final String ID_DUMMY2 = "yyy";

    @Before
    public void loginBefore() {
        super.login();
    }

    public BlobStoreInfo dummyStore1() {
        FileBlobStoreInfo config = new FileBlobStoreInfo(ID_DUMMY1);
        config.setFileSystemBlockSize(1024);
        config.setBaseDirectory("/tmp");
        return config;
    }

    public BlobStoreInfo dummyStore2() throws Exception {
        FileBlobStoreInfo config = new FileBlobStoreInfo(ID_DUMMY2);
        config.setFileSystemBlockSize(1024);
        config.setBaseDirectory("/tmp");
        return config;
    }

    @Test
    public void testPage() {
        BlobStoresPage page = new BlobStoresPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(BlobStoresPage.class);
        tester.assertComponent("storesPanel", GeoServerTablePanel.class);
        tester.assertComponent("confirmDeleteDialog", GeoServerDialog.class);
        tester.assertComponent("headerPanel:addNew", AjaxLink.class);
        tester.assertComponent("headerPanel:removeSelected", AjaxLink.class);
    }

    @Test
    public void testBlobStores() throws Exception {
        BlobStoresPage page = new BlobStoresPage();
        BlobStoreInfo dummy1 = this.dummyStore1();
        GWC.get().addBlobStore(dummy1);
        List blobStores = GWC.get().getBlobStores();
        tester.startPage((Page)page);
        GeoServerTablePanel table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("storesPanel");
        Assert.assertEquals((long)blobStores.size(), (long)table.getDataProvider().size());
        Assert.assertTrue((boolean)this.getStoresFromTable((GeoServerTablePanel<BlobStoreInfo>)table).contains(dummy1));
        BlobStoreInfo dummy2 = this.dummyStore2();
        GWC.get().addBlobStore(dummy2);
        Assert.assertEquals((long)(blobStores.size() + 1), (long)table.getDataProvider().size());
        Assert.assertTrue((boolean)this.getStoresFromTable((GeoServerTablePanel<BlobStoreInfo>)table).contains(dummy2));
        GWC.get().removeBlobStores(Collections.singleton(ID_DUMMY1));
        GWC.get().removeBlobStores(Collections.singleton(ID_DUMMY2));
    }

    @Test
    public void testNew() {
        BlobStoresPage page = new BlobStoresPage();
        tester.startPage((Page)page);
        tester.clickLink("headerPanel:addNew", true);
        tester.assertRenderedPage(BlobStorePage.class);
    }

    @Test
    public void testDelete() throws Exception {
        BlobStoresPage page = new BlobStoresPage();
        tester.startPage((Page)page);
        GeoServerTablePanel table = (GeoServerTablePanel)tester.getComponentFromLastRenderedPage("storesPanel");
        BlobStoreInfo dummy1 = this.dummyStore1();
        GWC.get().addBlobStore(dummy1);
        Assert.assertTrue((boolean)GWC.get().getBlobStores().contains(dummy1));
        tester.clickLink("storesPanel:listContainer:sortableLinks:0:header:link", true);
        tester.clickLink("storesPanel:listContainer:sortableLinks:0:header:link", true);
        this.print((Component)tester.getLastRenderedPage(), true, true);
        this.executeExactAjaxEventBehavior("storesPanel:listContainer:items:1:selectItemContainer:selectItem", "click", "true");
        CheckBox selector = (CheckBox)tester.getComponentFromLastRenderedPage("storesPanel:listContainer:items:1:selectItemContainer:selectItem");
        tester.getRequest().setParameter(selector.getInputName(), "true");
        tester.getRequest().setMethod("get");
        tester.executeAjaxEvent((Component)selector, "click");
        Assert.assertEquals((long)1L, (long)table.getSelection().size());
        Assert.assertEquals((Object)dummy1, table.getSelection().get(0));
        tester.clickLink("headerPanel:removeSelected", true);
        Assert.assertFalse((boolean)GWC.get().getBlobStores().contains(dummy1));
        GWC.get().addBlobStore(dummy1);
        Assert.assertTrue((boolean)GWC.get().getBlobStores().contains(dummy1));
        TileLayer layer = GWC.get().getTileLayerByName("cite:Lakes");
        layer.setBlobStoreId(ID_DUMMY1);
        Assert.assertEquals((Object)ID_DUMMY1, (Object)layer.getBlobStoreId());
        GWC.get().save(layer);
        tester.clickLink("storesPanel:listContainer:sortableLinks:0:header:link", true);
        tester.clickLink("storesPanel:listContainer:sortableLinks:0:header:link", true);
        selector = (CheckBox)tester.getComponentFromLastRenderedPage("storesPanel:listContainer:items:2:selectItemContainer:selectItem");
        tester.getRequest().setParameter(selector.getInputName(), "true");
        tester.getRequest().setMethod("get");
        tester.executeAjaxEvent((Component)selector, "click");
        Assert.assertEquals((long)1L, (long)table.getSelection().size());
        Assert.assertEquals((Object)dummy1, table.getSelection().get(0));
        GSModalWindow w = (GSModalWindow)tester.getComponentFromLastRenderedPage("confirmDeleteDialog:dialog");
        Assert.assertFalse((boolean)w.isShown());
        tester.clickLink("headerPanel:removeSelected", true);
        Assert.assertTrue((boolean)w.isShown());
        GeoServerDialog dialog = (GeoServerDialog)tester.getComponentFromLastRenderedPage("confirmDeleteDialog");
        dialog.submit((AjaxRequestTarget)new AjaxRequestHandler(tester.getLastRenderedPage()));
        Assert.assertFalse((boolean)GWC.get().getBlobStores().contains(dummy1));
        layer = GWC.get().getTileLayerByName("cite:Lakes");
        Assert.assertNull((Object)layer.getBlobStoreId());
    }

    public List<BlobStoreInfo> getStoresFromTable(GeoServerTablePanel<BlobStoreInfo> table) {
        ArrayList<BlobStoreInfo> result = new ArrayList<BlobStoreInfo>();
        Iterator it = table.getDataProvider().iterator(0L, (long)table.size());
        while (it.hasNext()) {
            result.add((BlobStoreInfo)it.next());
        }
        return result;
    }
}

