/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.Result;
import org.geoserver.catalog.PublishedType;
import org.geoserver.gwc.ConfigurableLockProvider;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.web.DefaultGridsetsEditor;
import org.geoserver.gwc.web.GWCSettingsPage;
import org.geoserver.gwc.web.InMemoryBlobStorePanel;
import org.geoserver.util.DimensionWarning;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geowebcache.locks.MemoryLockProvider;
import org.geowebcache.locks.NIOLockProvider;
import org.geowebcache.storage.blobstore.memory.CacheConfiguration;
import org.geowebcache.storage.blobstore.memory.guava.GuavaCacheProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GWCSettingsPageTest
extends GeoServerWicketTestSupport {
    @Before
    public void loginBefore() {
        super.login();
    }

    @Before
    public void cleanupBogusVectorFormat() throws IOException {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.getDefaultVectorCacheFormats().remove("foo/bar");
        gwc.saveConfig(config);
    }

    @Test
    public void testPageLoad() {
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GWCSettingsPage.class);
    }

    @Before
    public void cleanup() throws IOException {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.setCacheLayersByDefault(true);
        config.setLockProviderName(null);
        config.setInnerCachingEnabled(false);
        gwc.saveConfig(config);
    }

    @Test
    public void testEditDirectWMSIntegration() {
        GWC gwc = GWC.get();
        boolean directWMSIntegrationEnabled = gwc.getConfig().isDirectWMSIntegrationEnabled();
        this.testEditCheckboxOption("form:gwcServicesPanel:enableWMSIntegration", "gwcServicesPanel:enableWMSIntegration", directWMSIntegrationEnabled);
        Assert.assertEquals((Object)(!directWMSIntegrationEnabled ? 1 : 0), (Object)gwc.getConfig().isDirectWMSIntegrationEnabled());
    }

    @Test
    public void testEditRequireTiledParameter() {
        GWC gwc = GWC.get();
        boolean enabled = gwc.getConfig().isRequireTiledParameter();
        this.testEditCheckboxOption("form:gwcServicesPanel:requireTiledParameter", "gwcServicesPanel:requireTiledParameter", enabled);
        Assert.assertEquals((Object)(!enabled ? 1 : 0), (Object)gwc.getConfig().isRequireTiledParameter());
    }

    @Test
    public void testRequireTiledParameterDefaultsTrue() {
        GWC gwc = GWC.get();
        boolean enabled = gwc.getConfig().isRequireTiledParameter();
        Assert.assertTrue((boolean)enabled);
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GWCSettingsPage.class);
        Assert.assertNotNull((String)"form:gwcServicesPanel:requireTiledParameter", (Object)tester.getComponentFromLastRenderedPage("form:gwcServicesPanel:requireTiledParameter"));
        tester.assertModelValue("form:gwcServicesPanel:requireTiledParameter", (Object)true);
    }

    @Test
    public void testEditEnableWMSC() {
        GWC gwc = GWC.get();
        boolean enabled = gwc.getConfig().isWMSCEnabled();
        this.testEditCheckboxOption("form:gwcServicesPanel:enableWMSC", "gwcServicesPanel:enableWMSC", enabled);
        Assert.assertEquals((Object)(!enabled ? 1 : 0), (Object)gwc.getConfig().isWMSCEnabled());
    }

    @Test
    public void testEnableCacheLayersByDefault() throws Exception {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.setCacheLayersByDefault(false);
        gwc.saveConfig(config);
        Assert.assertFalse((boolean)gwc.getConfig().isCacheLayersByDefault());
        this.testEditCheckboxOption("form:cachingOptionsPanel:cacheLayersByDefault", "cachingOptionsPanel:cacheLayersByDefault", false);
        Assert.assertTrue((boolean)gwc.getConfig().isCacheLayersByDefault());
    }

    @Test
    public void testDisableCacheLayersByDefault() throws Exception {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.setCacheLayersByDefault(true);
        gwc.saveConfig(config);
        Assert.assertTrue((boolean)gwc.getConfig().isCacheLayersByDefault());
        this.testEditCheckboxOption("form:cachingOptionsPanel:cacheLayersByDefault", "cachingOptionsPanel:cacheLayersByDefault", true);
        Assert.assertFalse((boolean)gwc.getConfig().isCacheLayersByDefault());
    }

    @Test
    public void testEnableAutoCacheStyles() throws Exception {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.setCacheLayersByDefault(true);
        config.setCacheNonDefaultStyles(false);
        gwc.saveConfig(config);
        Assert.assertFalse((boolean)gwc.getConfig().isCacheNonDefaultStyles());
        this.testEditCheckboxOption("form:cachingOptionsPanel:container:configs:cacheNonDefaultStyles", "cachingOptionsPanel:container:configs:cacheNonDefaultStyles", false);
        Assert.assertTrue((boolean)gwc.getConfig().isCacheNonDefaultStyles());
    }

    @Test
    public void testDisableAutoCacheStyles() throws Exception {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.setCacheLayersByDefault(true);
        config.setCacheNonDefaultStyles(true);
        gwc.saveConfig(config);
        Assert.assertTrue((boolean)gwc.getConfig().isCacheNonDefaultStyles());
        this.testEditCheckboxOption("form:cachingOptionsPanel:container:configs:cacheNonDefaultStyles", "cachingOptionsPanel:container:configs:cacheNonDefaultStyles", true);
        Assert.assertFalse((boolean)gwc.getConfig().isCacheNonDefaultStyles());
    }

    @Test
    public void testSetDefaultCacheFormats() throws Exception {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.setCacheLayersByDefault(true);
        config.getDefaultVectorCacheFormats().add("foo/bar");
        gwc.saveConfig(config);
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GWCSettingsPage.class);
        ArrayList<String> vectorFormats = new ArrayList<String>(GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.VECTOR));
        vectorFormats.add("foo/bar");
        ArrayList rasterFormats = new ArrayList(GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.RASTER));
        ArrayList groupFormats = new ArrayList(GWC.getAdvertisedCachedFormats((PublishedType)PublishedType.GROUP));
        tester.assertComponent("form:cachingOptionsPanel:container:configs:vectorFormatsGroup:vectorFromats", ListView.class);
        tester.assertModelValue("form:cachingOptionsPanel:container:configs:vectorFormatsGroup:vectorFromats", vectorFormats);
        tester.assertComponent("form:cachingOptionsPanel:container:configs:rasterFormatsGroup:rasterFromats", ListView.class);
        tester.assertModelValue("form:cachingOptionsPanel:container:configs:rasterFormatsGroup:rasterFromats", rasterFormats);
        tester.assertComponent("form:cachingOptionsPanel:container:configs:otherFormatsGroup:otherFromats", ListView.class);
        tester.assertModelValue("form:cachingOptionsPanel:container:configs:otherFormatsGroup:otherFromats", groupFormats);
        FormTester form = tester.newFormTester("form");
        boolean replace = true;
        form.selectMultiple("cachingOptionsPanel:container:configs:vectorFormatsGroup", new int[]{1, 3}, true);
        form.selectMultiple("cachingOptionsPanel:container:configs:rasterFormatsGroup", new int[]{1, 3}, true);
        form.selectMultiple("cachingOptionsPanel:container:configs:otherFormatsGroup", new int[]{1, 3}, true);
        form.submit("submit");
        tester.assertRenderedPage(GeoServerHomePage.class);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{(String)vectorFormats.get(1), (String)vectorFormats.get(3)}), (Object)gwc.getConfig().getDefaultVectorCacheFormats());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{(String)rasterFormats.get(1), (String)rasterFormats.get(3)}), (Object)gwc.getConfig().getDefaultCoverageCacheFormats());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{(String)groupFormats.get(1), (String)groupFormats.get(3)}), (Object)gwc.getConfig().getDefaultOtherCacheFormats());
    }

    private void testEditCheckboxOption(String pagePath, String formPath, Boolean initialValue) {
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GWCSettingsPage.class);
        Assert.assertNotNull((String)pagePath, (Object)tester.getComponentFromLastRenderedPage(pagePath));
        tester.assertModelValue(pagePath, (Object)initialValue);
        FormTester form = tester.newFormTester("form");
        form.setValue(formPath, initialValue == false);
        form.submit("submit");
        tester.assertRenderedPage(GeoServerHomePage.class);
    }

    @Test
    public void testEditLockProvider() {
        GWC gwc = GWC.get();
        ConfigurableLockProvider lockProvider = (ConfigurableLockProvider)gwc.getLockProvider();
        Assert.assertTrue((boolean)(lockProvider.getDelegate() instanceof MemoryLockProvider));
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GWCSettingsPage.class);
        DropDownChoice lockDropDown = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:cachingOptionsPanel:container:configs:lockProvider");
        List choices = lockDropDown.getChoices();
        int nioLockIndex = -1;
        for (int i = 0; i < choices.size(); ++i) {
            if (!"nioLock".equals(choices.get(i))) continue;
            nioLockIndex = i;
            break;
        }
        Assert.assertTrue((nioLockIndex >= 0 ? 1 : 0) != 0);
        FormTester form = tester.newFormTester("form");
        form.select("cachingOptionsPanel:container:configs:lockProvider", nioLockIndex);
        form.submit("submit");
        tester.assertNoErrorMessage();
        lockProvider = (ConfigurableLockProvider)gwc.getLockProvider();
        Assert.assertTrue((boolean)(lockProvider.getDelegate() instanceof NIOLockProvider));
    }

    @Test
    public void testNewDefaultGridSet() throws IOException {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.setCacheLayersByDefault(true);
        gwc.saveConfig(config);
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GWCSettingsPage.class);
        tester.assertComponent("form:cachingOptionsPanel:container:configs:cachedGridsets", DefaultGridsetsEditor.class);
        DropDownChoice availableItems = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:cachingOptionsPanel:container:configs:cachedGridsets:availableGridsets");
        Assert.assertNotNull((Object)availableItems);
        String item = (String)availableItems.getChoices().get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"CanadianNAD83_LCC", (Object)item);
        FormTester form = tester.newFormTester("form", false);
        form.select("cachingOptionsPanel:container:configs:cachedGridsets:availableGridsets", 0);
        tester.executeAjaxEvent("form:cachingOptionsPanel:container:configs:cachedGridsets:addGridset", "click");
        tester.assertRenderedPage(GWCSettingsPage.class);
        form = tester.newFormTester("form", false);
        form.select("cachingOptionsPanel:container:configs:cachedGridsets:availableGridsets", 0);
        form.submit("submit");
        tester.assertNoErrorMessage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GWCSettingsPage.class);
        availableItems = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:cachingOptionsPanel:container:configs:cachedGridsets:availableGridsets");
        Assert.assertFalse((boolean)availableItems.getChoices().contains(item));
    }

    @Test
    public void testEnableDisableInnerCaching() throws Exception {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        tester.assertRenderedPage(GWCSettingsPage.class);
        tester.assertComponent("form:cachingOptionsPanel:container:configs:blobstores", InMemoryBlobStorePanel.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("cachingOptionsPanel:container:configs:blobstores:innerCachingEnabled", true);
        tester.assertRenderedPage(GWCSettingsPage.class);
        form.submit("submit");
        tester.assertNoErrorMessage();
        config = gwc.getConfig();
        Assert.assertTrue((boolean)config.isInnerCachingEnabled());
        tester.startPage((Page)new GWCSettingsPage());
        tester.assertRenderedPage(GWCSettingsPage.class);
        tester.assertComponent("form:cachingOptionsPanel:container:configs:blobstores:container:caches", DropDownChoice.class);
        DropDownChoice choice = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:cachingOptionsPanel:container:configs:blobstores:container:caches");
        Assert.assertTrue((boolean)((String)choice.getChoices().get(0)).equalsIgnoreCase(GuavaCacheProvider.class.toString()));
        Component comp1 = tester.getComponentFromLastRenderedPage("form:cachingOptionsPanel:container:configs:blobstores:container:cacheConfContainer:hardMemoryLimit");
        Component comp2 = tester.getComponentFromLastRenderedPage("form:cachingOptionsPanel:container:configs:blobstores:container:cacheConfContainer:concurrencyLevel");
        Assert.assertTrue((boolean)comp1.isEnabled());
        Assert.assertTrue((boolean)comp2.isEnabled());
        form = tester.newFormTester("form");
        form.setValue("cachingOptionsPanel:container:configs:blobstores:container:persistenceEnabled", true);
        form.setValue("cachingOptionsPanel:container:configs:blobstores:container:cacheConfContainer:hardMemoryLimit", "1");
        form.setValue("cachingOptionsPanel:container:configs:blobstores:container:cacheConfContainer:concurrencyLevel", "1");
        tester.assertRenderedPage(GWCSettingsPage.class);
        form.submit("submit");
        tester.assertNoErrorMessage();
        config = gwc.getConfig();
        Assert.assertTrue((boolean)config.isPersistenceEnabled());
        Assert.assertEquals((long)((CacheConfiguration)config.getCacheConfigurations().get(GuavaCacheProvider.class.toString())).getConcurrencyLevel(), (long)1L);
        Assert.assertEquals((long)((CacheConfiguration)config.getCacheConfigurations().get(GuavaCacheProvider.class.toString())).getHardMemoryLimit(), (long)1L);
        tester.startPage((Page)new GWCSettingsPage());
        tester.assertRenderedPage(GWCSettingsPage.class);
        form = tester.newFormTester("form");
        form.setValue("cachingOptionsPanel:container:configs:blobstores:innerCachingEnabled", false);
        form.submit("submit");
        tester.startPage((Page)new GWCSettingsPage());
        tester.assertRenderedPage(GWCSettingsPage.class);
        Result res = tester.isVisible("form:cachingOptionsPanel:container:configs:blobstores:container:persistenceEnabled");
        Assert.assertTrue((boolean)res.wasFailed());
        config = gwc.getConfig();
        Assert.assertFalse((boolean)config.isInnerCachingEnabled());
    }

    @Test
    public void testEvictionPolicy() {
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        FormTester form = tester.newFormTester("form");
        form.setValue("cachingOptionsPanel:container:configs:blobstores:innerCachingEnabled", true);
        form.submit("submit");
        tester.assertRenderedPage(GeoServerHomePage.class);
        tester.startPage((Page)new GWCSettingsPage());
        tester.assertComponent("form:cachingOptionsPanel:container:configs:blobstores:container:caches", DropDownChoice.class);
        DropDownChoice choice = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:cachingOptionsPanel:container:configs:blobstores:container:caches");
        Assert.assertTrue((boolean)((String)choice.getChoices().get(0)).equalsIgnoreCase(GuavaCacheProvider.class.toString()));
        DropDownChoice evictionPoliciesDropDown = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:cachingOptionsPanel:container:configs:blobstores:container:cacheConfContainer:policy");
        List evictionPolicies = evictionPoliciesDropDown.getChoices();
        Assert.assertEquals((long)3L, (long)evictionPolicies.size());
        Assert.assertTrue((boolean)evictionPolicies.contains(CacheConfiguration.EvictionPolicy.NULL));
        Assert.assertTrue((boolean)evictionPolicies.contains(CacheConfiguration.EvictionPolicy.EXPIRE_AFTER_ACCESS));
        Assert.assertTrue((boolean)evictionPolicies.contains(CacheConfiguration.EvictionPolicy.EXPIRE_AFTER_WRITE));
    }

    @Test
    public void testApply() {
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        FormTester form = tester.newFormTester("form");
        form.setValue("cachingOptionsPanel:container:configs:blobstores:innerCachingEnabled", true);
        form.submit("apply");
        tester.assertRenderedPage(GWCSettingsPage.class);
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        Assert.assertTrue((boolean)config.isInnerCachingEnabled());
    }

    @Test
    public void testMemoryCachePanelOpen() throws IOException {
        GWC gwc = GWC.get();
        GWCConfig config = gwc.getConfig();
        config.setInnerCachingEnabled(true);
        gwc.saveConfig(config);
        GWCSettingsPage page = new GWCSettingsPage();
        tester.startPage((Page)page);
        tester.assertVisible("form:cachingOptionsPanel:container:configs:blobstores:container");
    }

    @Test
    public void testSaveWarningSkips() {
        tester.startPage(GWCSettingsPage.class);
        FormTester ft = tester.newFormTester("form");
        String checksPath = "cachingOptionsPanel:container:configs:warningSkips:warningSkipsGroup";
        ft.select(checksPath, 0);
        ft.select(checksPath, 2);
        ft.submit("submit");
        tester.assertNoErrorMessage();
        GWC gwc = GWC.get();
        GWCConfig gwcConfig = gwc.getConfig();
        MatcherAssert.assertThat((Object)gwcConfig.getCacheWarningSkips(), (Matcher)Matchers.containsInAnyOrder((Object[])new DimensionWarning.WarningType[]{DimensionWarning.WarningType.Default, DimensionWarning.WarningType.FailedNearest}));
    }

    @Test
    public void testEditMetatilingThreads() {
        GWC gwc = GWC.get();
        this.testEditMetatilingThreads("3");
        tester.assertNoErrorMessage();
        Assert.assertEquals((long)3L, (long)((ThreadPoolExecutor)gwc.getMetaTilingExecutor()).getCorePoolSize());
        this.testEditMetatilingThreads("-1");
        tester.assertErrorMessages(new Serializable[]{"The value of 'Metatiling threads count (unset for automatic detection)' must be at least 0."});
        Assert.assertEquals((long)3L, (long)((ThreadPoolExecutor)gwc.getMetaTilingExecutor()).getCorePoolSize());
        this.testEditMetatilingThreads("");
        tester.assertNoErrorMessage();
        int cores = Runtime.getRuntime().availableProcessors();
        Assert.assertEquals((long)(cores * 2), (long)((ThreadPoolExecutor)gwc.getMetaTilingExecutor()).getCorePoolSize());
    }

    private void testEditMetatilingThreads(String threadCount) {
        tester.startPage(GWCSettingsPage.class);
        tester.assertRenderedPage(GWCSettingsPage.class);
        FormTester form = tester.newFormTester("form");
        form.setValue("gwcServicesPanel:metaTilingThreads", threadCount);
        form.submit("submit");
    }
}

