/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.DynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.geoserver.catalog.PublishedType;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.CommonFormatLink;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.web.demo.PreviewLayerProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wms.GetMapOutputFormat;

public class MapPreviewPage
extends GeoServerBasePage {
    private static final long serialVersionUID = 1L;
    private static final PackageResourceReference JS_FILE = new PackageResourceReference(MapPreviewPage.class, "MapPreviewPage.js");
    PreviewLayerProvider provider = new PreviewLayerProvider();
    GeoServerTablePanel<PreviewLayer> table;
    private transient List<String> availableWMSFormats;

    public MapPreviewPage() {
        final List<String> wmsOutputFormats = this.getAvailableWMSFormats();
        final List<String> wfsOutputFormats = this.getAvailableWFSFormats();
        this.table = new GeoServerTablePanel<PreviewLayer>("table", (GeoServerDataProvider)this.provider){
            private static final long serialVersionUID = 1L;

            protected Component getComponentForProperty(String id, IModel<PreviewLayer> itemModel, GeoServerDataProvider.Property<PreviewLayer> property) {
                PreviewLayer layer = (PreviewLayer)itemModel.getObject();
                boolean wmsVisible = layer.hasServiceSupport("WMS");
                boolean wfsVisible = layer.hasServiceSupport("WFS");
                if (property == PreviewLayerProvider.TYPE) {
                    Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)MapPreviewPage.this);
                    f.add(new Component[]{new Image("layerIcon", (ResourceReference)layer.getIcon(), new ResourceReference[0])});
                    return f;
                }
                if (property == PreviewLayerProvider.NAME) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == PreviewLayerProvider.TITLE) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == PreviewLayerProvider.COMMON) {
                    Fragment f = new Fragment(id, "commonLinks", (MarkupContainer)MapPreviewPage.this);
                    ListView<ExternalLink> lv = new ListView<ExternalLink>("commonFormat", MapPreviewPage.this.commonFormatLinks(layer)){

                        public void populateItem(ListItem<ExternalLink> item) {
                            ExternalLink link = (ExternalLink)item.getModelObject();
                            item.add(new Component[]{link});
                        }
                    };
                    f.add(new Component[]{lv});
                    return f;
                }
                if (property == PreviewLayerProvider.ALL) {
                    return MapPreviewPage.this.buildJSWMSSelect(id, wmsVisible ? wmsOutputFormats : Collections.emptyList(), wfsVisible ? wfsOutputFormats : Collections.emptyList(), layer);
                }
                throw new IllegalArgumentException("Don't know a property named " + property.getName());
            }
        };
        this.table.setTableChangeJS("MapPreviewPage_SetOnChange();");
        this.add(new Component[]{this.table.setOutputMarkupId(true)});
        int maxFeatures = ((WFSInfo)this.getGeoServer().getService(WFSInfo.class)).getMaxNumberOfFeaturesForPreview();
        this.add(new Component[]{new HiddenField("maxFeatures", (IModel)Model.of((Serializable)Integer.valueOf(maxFeatures))).setOutputMarkupId(true)});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)JS_FILE));
    }

    private List<ExternalLink> commonFormatLinks(PreviewLayer layer) {
        ArrayList<ExternalLink> links = new ArrayList<ExternalLink>();
        List formats = this.getGeoServerApplication().getBeansOfType(CommonFormatLink.class);
        Collections.sort(formats);
        for (CommonFormatLink link : formats) {
            links.add(link.getFormatLink(layer));
        }
        return links;
    }

    private List<String> getAvailableWMSFormats() {
        List<String> formats = this.availableWMSFormats;
        if (formats != null) {
            return formats;
        }
        formats = new ArrayList<String>();
        GeoServerApplication application = this.getGeoServerApplication();
        List outputFormats = application.getBeansOfType(GetMapOutputFormat.class);
        for (GetMapOutputFormat producer : outputFormats) {
            HashSet<String> producerFormats = new HashSet<String>(producer.getOutputFormatNames());
            producerFormats.add(producer.getMimeType());
            String knownFormat = producer.getMimeType();
            for (String formatName : producerFormats) {
                String translatedFormatName;
                if (formatName.equals(translatedFormatName = this.translateFormat("format.wms.", formatName))) continue;
                knownFormat = formatName;
                break;
            }
            formats.add(knownFormat);
        }
        formats = new ArrayList<String>(new HashSet<String>(formats));
        this.prepareFormatList(formats, new FormatComparator("format.wms."));
        this.availableWMSFormats = formats;
        return formats;
    }

    private List<String> getAvailableWFSFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        GeoServerApplication application = this.getGeoServerApplication();
        for (WFSGetFeatureOutputFormat producer : application.getBeansOfType(WFSGetFeatureOutputFormat.class)) {
            for (String format : producer.getOutputFormats()) {
                formats.add(format);
            }
        }
        this.prepareFormatList(formats, new FormatComparator("format.wfs."));
        return formats;
    }

    private void prepareFormatList(List<String> formats, FormatComparator comparator) {
        Collections.sort(formats, comparator);
        String prev = null;
        Iterator<String> it = formats.iterator();
        while (it.hasNext()) {
            String format = it.next();
            if (prev != null && comparator.compare(format, prev) == 0) {
                it.remove();
            }
            prev = format;
        }
    }

    private Component buildJSWMSSelect(String id, List<String> wmsOutputFormats, List<String> wfsOutputFormats, PreviewLayer layer) {
        Fragment f = new Fragment(id, "menuFragment", (MarkupContainer)this);
        WebMarkupContainer menu = new WebMarkupContainer("menu");
        WebMarkupContainer wmsFormatsGroup = new WebMarkupContainer("wms");
        RepeatingView wmsFormats = new RepeatingView("wmsFormats");
        for (int i = 0; i < wmsOutputFormats.size(); ++i) {
            String wmsOutputFormat = wmsOutputFormats.get(i);
            String label = this.translateFormat("format.wms.", wmsOutputFormat);
            Label format = new Label("" + i, (Serializable)((Object)label));
            format.add(new Behavior[]{new AttributeModifier("value", (IModel)new Model((Serializable)((Object)ResponseUtils.urlEncode((String)wmsOutputFormat, (char[])new char[0]))))});
            wmsFormats.add(new Component[]{format});
        }
        wmsFormatsGroup.add(new Component[]{wmsFormats});
        wmsFormatsGroup.setVisible(CollectionUtils.isNotEmpty(wmsOutputFormats));
        menu.add(new Component[]{wmsFormatsGroup});
        boolean vector = layer.groupInfo == null && (layer.layerInfo.getType() == PublishedType.VECTOR || layer.layerInfo.getType() == PublishedType.REMOTE);
        WebMarkupContainer wfsFormatsGroup = new WebMarkupContainer("wfs");
        RepeatingView wfsFormats = new RepeatingView("wfsFormats");
        if (vector) {
            for (int i = 0; i < wfsOutputFormats.size(); ++i) {
                String wfsOutputFormat = wfsOutputFormats.get(i);
                String label = this.translateFormat("format.wfs.", wfsOutputFormat);
                Label format = new Label("" + i, (Serializable)((Object)label));
                format.add(new Behavior[]{new AttributeModifier("value", (IModel)new Model((Serializable)((Object)ResponseUtils.urlEncode((String)wfsOutputFormat, (char[])new char[0]))))});
                wfsFormats.add(new Component[]{format});
            }
        }
        wfsFormatsGroup.add(new Component[]{wfsFormats});
        wfsFormatsGroup.setVisible(CollectionUtils.isNotEmpty(wfsOutputFormats));
        menu.add(new Component[]{wfsFormatsGroup});
        menu.add(new Behavior[]{new AttributeAppender("wmsLink", (IModel)new Model((Serializable)((Object)layer.getWmsLink())), ";")});
        menu.add(new Behavior[]{new AttributeAppender("wfsLink", (IModel)new Model((Serializable)((Object)layer.buildWfsLink())), ";")});
        f.add(new Component[]{menu});
        return f;
    }

    private String translateFormat(String prefix, String format) {
        try {
            return this.getLocalizer().getString(prefix + format, (Component)this);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, e.getMessage());
            return format;
        }
    }

    private static class DelayedImageResource
    extends DynamicImageResource {
        private final IModel<PreviewLayer> itemModel;

        public DelayedImageResource(IModel<PreviewLayer> itemModel) {
            super("image/png");
            this.itemModel = itemModel;
        }

        protected byte[] getImageData(IResource.Attributes attributes) {
            PreviewLayer layer = (PreviewLayer)this.itemModel.getObject();
            try {
                return IOUtils.toByteArray((InputStream)layer.getIcon().getResource().getResourceStream().getInputStream());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class FormatComparator
    implements Comparator<String> {
        String prefix;

        public FormatComparator(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public int compare(String f1, String f2) {
            String t1 = MapPreviewPage.this.translateFormat(this.prefix, f1);
            String t2 = MapPreviewPage.this.translateFormat(this.prefix, f2);
            return t1.compareTo(t2);
        }
    }
}

