/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequest;
import org.geoserver.web.wicket.CodeMirrorEditor;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geotools.util.logging.Logging;

public class DemoRequestsPage
extends GeoServerBasePage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.web.demo");
    public static String demoRequestsJavascript;
    public static String demoRequestsCSS;
    Resource demoDir;
    private TextField<String> urlTextField;
    private CodeMirrorEditor body;
    private TextField<String> username;
    private PasswordTextField password;
    private CheckBox prettyXML;
    private CheckBox openNewPage;

    public DemoRequestsPage(PageParameters parameters) {
        super(parameters);
        this.setup();
        if (parameters != null) {
            if (parameters.get("xml") != null) {
                ((DemoRequest)this.getDefaultModel().getObject()).setRequestBody(parameters.get("xml").toString());
            }
            if (parameters.get("url") != null) {
                ((DemoRequest)this.getDefaultModel().getObject()).setRequestUrl(parameters.get("url").toString());
            }
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptContentHeaderItem.forScript((CharSequence)demoRequestsJavascript, null));
        response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)demoRequestsCSS, (String)"demoRequestsCSS"));
        Object script = "\n";
        script = (String)script + "$('#linkSubmit').on('click',function() {\ndocument.getElementById('openNewWindow').checked = false; \nsubmitRequest();\n} \n);\n\n";
        script = (String)script + "$('#linkSubmitNewWin').on('click',function() {\ndocument.getElementById('openNewWindow').checked = true;\nsubmitRequest();\n} );\n\n";
        script = (String)script + "\n";
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
    }

    public void setup() {
        try {
            GeoServerResourceLoader loader = this.getGeoServer().getCatalog().getResourceLoader();
            this.demoDir = Resources.serializable((Resource)loader.get("demo"));
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Can't access demo requests directory: " + e.getMessage());
        }
        DemoRequest request = new DemoRequest(this.demoDir.path());
        this.setDefaultModel((IModel)new Model((Serializable)request));
        this.setUpDemoRequestsForm(this.demoDir);
    }

    public DemoRequestsPage() {
        this.setup();
    }

    DemoRequestsPage(Resource demoDir) {
        this.demoDir = Resources.serializable((Resource)demoDir);
        DemoRequest model = new DemoRequest(demoDir.path());
        this.setDefaultModel((IModel)new Model((Serializable)model));
        this.setUpDemoRequestsForm(demoDir);
    }

    DemoRequestsPage(Resource demoDir, PageParameters parameters) {
        this(demoDir);
        if (parameters != null) {
            if (parameters.get("xml") != null) {
                ((DemoRequest)this.getDefaultModel().getObject()).setRequestBody(parameters.get("xml").toString());
            }
            if (parameters.get("url") != null) {
                ((DemoRequest)this.getDefaultModel().getObject()).setRequestUrl(parameters.get("url").toString());
            }
        }
    }

    private String getFileContents(String reqFileName) throws IOException {
        Resource file = this.demoDir.get(reqFileName);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.in()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private void setUpDemoRequestsForm(Resource demoDir) {
        IModel requestModel = this.getDefaultModel();
        Form demoRequestsForm = new Form("demoRequestsForm");
        demoRequestsForm.setOutputMarkupId(true);
        demoRequestsForm.setModel(requestModel);
        this.add(new Component[]{demoRequestsForm});
        List<String> demoList = this.getDemoList(demoDir);
        PropertyModel reqFileNameModel = new PropertyModel((Object)requestModel, "requestFileName");
        Select2DropDownChoice demoRequestsList = new Select2DropDownChoice("demoRequestsList", (IModel)reqFileNameModel, demoList, (IChoiceRenderer)new ChoiceRenderer<String>(){

            public String getIdValue(String obj, int index) {
                return obj;
            }

            public Object getDisplayValue(String obj) {
                return obj;
            }
        });
        demoRequestsForm.add(new Component[]{demoRequestsList});
        demoRequestsList.add(new Behavior[]{new AjaxFormSubmitBehavior(demoRequestsForm, "change", (DropDownChoice)demoRequestsList){
            final /* synthetic */ DropDownChoice val$demoRequestsList;
            {
                this.val$demoRequestsList = dropDownChoice;
                super(form, event);
            }

            protected void onSubmit(AjaxRequestTarget target) {
                String contents;
                GeoServer gs;
                String reqFileName = this.val$demoRequestsList.getModelValue();
                HttpServletRequest httpServletRequest = DemoRequestsPage.this.getGeoServerApplication().servletRequest(DemoRequestsPage.this.getRequest());
                String proxyBaseUrl = GeoServerExtensions.getProperty((String)"PROXY_BASE_URL");
                String baseUrl = StringUtils.isEmpty((CharSequence)proxyBaseUrl) ? (StringUtils.isEmpty((CharSequence)(proxyBaseUrl = (gs = DemoRequestsPage.this.getGeoServer()).getGlobal().getSettings().getProxyBaseUrl())) ? ResponseUtils.baseURL((HttpServletRequest)httpServletRequest) : proxyBaseUrl) : proxyBaseUrl;
                try {
                    contents = DemoRequestsPage.this.getFileContents(reqFileName);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Can't load demo file " + reqFileName, e);
                    throw new WicketRuntimeException("Can't load demo file " + reqFileName, (Throwable)e);
                }
                boolean demoRequestIsHttpGet = reqFileName.endsWith(".url");
                String service = reqFileName.substring(0, reqFileName.indexOf(95)).toLowerCase();
                if (demoRequestIsHttpGet) {
                    String url = ResponseUtils.appendPath((String[])new String[]{baseUrl, contents});
                    DemoRequestsPage.this.urlTextField.setModelObject((Object)url);
                    DemoRequestsPage.this.body.setModelObject((Object)"");
                } else {
                    String serviceUrl = ResponseUtils.appendPath((String[])new String[]{baseUrl, service});
                    DemoRequestsPage.this.urlTextField.setModelObject((Object)serviceUrl);
                    DemoRequestsPage.this.body.setModelObject((Object)contents);
                }
                DemoRequestsPage.this.setResponsePage((IRequestablePage)DemoRequestsPage.this);
            }

            protected void onError(AjaxRequestTarget target) {
            }
        }});
        this.urlTextField = new TextField("url", (IModel)new PropertyModel((Object)requestModel, "requestUrl"));
        this.urlTextField.setMarkupId("requestUrl");
        this.urlTextField.setOutputMarkupId(true);
        demoRequestsForm.add(new Component[]{this.urlTextField});
        this.body = new CodeMirrorEditor("body", (IModel)new PropertyModel((Object)requestModel, "requestBody"));
        this.body.setTextAreaMarkupId("requestBody");
        demoRequestsForm.add(new Component[]{this.body});
        this.username = new TextField("username", (IModel)new PropertyModel((Object)requestModel, "userName"));
        demoRequestsForm.add(new Component[]{this.username});
        this.password = new PasswordTextField("password", (IModel)new PropertyModel((Object)requestModel, "password"));
        this.password.setRequired(false);
        this.password.setResetPassword(false);
        demoRequestsForm.add(new Component[]{this.password});
        this.prettyXML = new CheckBox("prettyXML", (IModel)new PropertyModel((Object)requestModel, "prettyXML"));
        demoRequestsForm.add(new Component[]{this.prettyXML});
        this.openNewPage = new CheckBox("openNewWindow", (IModel)new PropertyModel((Object)requestModel, "openNewWindow"));
        demoRequestsForm.add(new Component[]{this.openNewPage});
    }

    private List<String> getDemoList(Resource demoDir) {
        ArrayList<String> demoList = new ArrayList<String>();
        for (Resource file : demoDir.list()) {
            if (file.getType() == Resource.Type.DIRECTORY) continue;
            String name = file.name();
            if (name.endsWith(".url") || name.endsWith(".xml")) {
                demoList.add(name);
                continue;
            }
            LOGGER.warning("Ignoring file " + name + " in demo requests directory, only .url and .xml files allowed");
        }
        Collections.sort(demoList);
        return demoList;
    }

    static {
        try {
            String demo_request_js = CharStreams.toString((Readable)new InputStreamReader(DemoRequestsPage.class.getResourceAsStream("/org/geoserver/web/demo/demo-requests.js"), StandardCharsets.UTF_8));
            String xml_pretty_print_js = CharStreams.toString((Readable)new InputStreamReader(DemoRequestsPage.class.getResourceAsStream("/org/geoserver/web/demo/xml-pretty-print.js"), StandardCharsets.UTF_8));
            String js = demo_request_js + "\n" + xml_pretty_print_js;
            demoRequestsJavascript = js;
            demoRequestsCSS = CharStreams.toString((Readable)new InputStreamReader(DemoRequestsPage.class.getResourceAsStream("/org/geoserver/web/demo/demo-requests.css"), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "error occurred reading demoRequestsJavascript", e);
        }
    }
}

