/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.crs;

import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.geoserver.web.crs.CRSAreaOfValidityMapBuilder;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class DynamicCrsMapResource
extends AbstractResource {
    static final Logger LOGGER = Logging.getLogger(DynamicCrsMapResource.class);
    private static final long serialVersionUID = 1L;
    private final CoordinateReferenceSystem crs;

    public DynamicCrsMapResource(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse rsp = new AbstractResource.ResourceResponse();
        rsp.setWriteCallback(new AbstractResource.WriteCallback(){

            public void writeData(IResource.Attributes attributes) throws IOException {
                byte[] byteArray;
                IRequestParameters params = attributes.getRequest().getQueryParameters();
                int width = params.getParameterValue("WIDTH").toInt(400);
                int height = params.getParameterValue("HEIGHT").toInt(200);
                String bboxStr = params.getParameterValue("BBOX").toOptionalString();
                ByteArrayOutputStream output = null;
                if (bboxStr != null) {
                    try {
                        CRSAreaOfValidityMapBuilder builder = new CRSAreaOfValidityMapBuilder(width, height);
                        Envelope envelope = DynamicCrsMapResource.this.parseEnvelope(bboxStr);
                        RenderedImage image = builder.createMapFor(DynamicCrsMapResource.this.crs, envelope);
                        output = new ByteArrayOutputStream();
                        ImageIO.write(image, "PNG", output);
                    }
                    catch (Exception e) {
                        output = null;
                        LOGGER.log(Level.WARNING, "", e);
                    }
                }
                byte[] byArray = byteArray = output == null ? null : output.toByteArray();
                if (byteArray != null) {
                    attributes.getResponse().write(byteArray);
                }
            }
        });
        return rsp;
    }

    private Envelope parseEnvelope(String bboxStr) {
        String[] split = bboxStr.split(",");
        double minx = Double.valueOf(split[0]);
        double miny = Double.valueOf(split[1]);
        double maxx = Double.valueOf(split[2]);
        double maxy = Double.valueOf(split[3]);
        return new Envelope(minx, maxx, miny, maxy);
    }

    private static class ByteArrayResourceStream
    extends AbstractResourceStream {
        private static final long serialVersionUID = 1L;
        private final byte[] content;

        public ByteArrayResourceStream(byte[] content) {
            this.content = content;
        }

        public void setLocale(Locale arg0) {
        }

        public Bytes length() {
            return Bytes.bytes((long)(this.content == null ? 0L : (long)this.content.length));
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            if (this.content == null) {
                throw new ResourceStreamNotFoundException();
            }
            return new ByteArrayInputStream(this.content);
        }

        public String getContentType() {
            return "image/png";
        }

        public void close() throws IOException {
        }
    }
}

