/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.HeaderContribution;
import org.geoserver.web.demo.SRSDescriptionPage;
import org.geoserver.web.demo.SRSListPage;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SRSListPageTest
extends GeoServerWicketTestSupport {
    @Rule
    public GeoServerExtensionsHelper.ExtensionsHelperRule extensions = new GeoServerExtensionsHelper.ExtensionsHelperRule();

    @Test
    public void testBasicPage() throws Exception {
        tester.startPage(SRSListPage.class);
        tester.assertLabel("srsListPanel:table:listContainer:items:1:itemProperties:0:component:link:label", "CRS:27");
        tester.clickLink("srsListPanel:table:listContainer:items:1:itemProperties:0:component:link");
        tester.assertRenderedPage(SRSDescriptionPage.class);
    }

    @Test
    public void testHeaderContribution() throws Exception {
        HeaderContribution testHeaderContribution = new HeaderContribution();
        testHeaderContribution.setCSSFilename("testHeaderContribution.css");
        testHeaderContribution.setScope(((Object)((Object)this)).getClass());
        this.extensions.singleton("testHeaderContribution", (Object)testHeaderContribution, new Class[]{HeaderContribution.class});
        tester.startPage(SRSListPage.class);
        tester.clickLink("srsListPanel:table:listContainer:items:1:itemProperties:0:component:link");
        tester.assertRenderedPage(SRSDescriptionPage.class);
        Assert.assertTrue((boolean)tester.getLastResponse().getDocument().contains("testHeaderContribution.css"));
    }

    @Test
    public void testIAUCodes() throws Exception {
        tester.startPage(SRSListPage.class);
        FormTester ft = tester.newFormTester("srsListPanel:table:filterForm");
        ft.setValue("filter", "IAU:30115");
        ft.submit("submit");
        AtomicBoolean found = new AtomicBoolean(false);
        tester.getLastRenderedPage().visitChildren(AjaxLink.class, (link, visit) -> {
            if ("IAU:30115".equals(link.getDefaultModelObjectAsString())) {
                visit.stop();
                found.set(true);
            }
        });
        Assert.assertTrue((boolean)found.get());
    }
}

