/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.web.demo.PreviewLayerProvider;
import org.junit.Assert;
import org.junit.Test;

public class PreviewLayerProviderTest
extends GeoServerWicketTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAdvertisedLayer() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            PreviewLayer pl = this.getPreviewLayer(provider, layerId);
            Assert.assertNotNull((Object)pl);
            layer.setAdvertised(false);
            this.getCatalog().save(layer);
            pl = this.getPreviewLayer(provider, layerId);
            Assert.assertNull((Object)pl);
        }
        finally {
            layer.setAdvertised(true);
            this.getCatalog().save(layer);
        }
    }

    @Test
    public void testWmsLinkParametersOfLayer() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        PreviewLayerProvider provider = new PreviewLayerProvider();
        PreviewLayer pl = this.getPreviewLayer(provider, layerId);
        Assert.assertNotNull((Object)pl);
        String wmsLink = pl.getWmsLink();
        String[] wmsParams = wmsLink.substring(wmsLink.indexOf("?") + 1).split("&");
        HashSet<String> wmsKeys = new HashSet<String>();
        for (String param : wmsParams) {
            String[] wmsParam = param.split("=");
            if (wmsParam.length <= 0) continue;
            wmsKeys.add(wmsParam[0]);
        }
        List<String> keysToCheck = Arrays.asList("service", "version", "request", "layers", "bbox", "width", "height", "srs", "styles");
        for (String key : keysToCheck) {
            if (wmsKeys.contains(key)) continue;
            Assert.fail((String)String.format("Parameter '%s' not specified in WmsLink URL of Layer.", key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleLayerGroup() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        LayerGroupInfo group = this.getCatalog().getFactory().createLayerGroup();
        group.setName("testSingleLayerGroup");
        group.setMode(LayerGroupInfo.Mode.SINGLE);
        group.getLayers().add(layer);
        group.setTitle("This is the title");
        group.setAbstract("This is the abstract");
        this.getCatalog().add(group);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            PreviewLayer pl = this.getPreviewLayer(provider, group.prefixedName());
            Assert.assertNotNull((Object)pl);
            Assert.assertEquals((Object)"This is the title", (Object)pl.getTitle());
            Assert.assertEquals((Object)"This is the abstract", (Object)pl.getAbstract());
        }
        finally {
            this.getCatalog().remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisabledLayerGroup() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        LayerGroupInfo group = this.getCatalog().getFactory().createLayerGroup();
        group.setName("testSingleLayerGroup");
        group.setMode(LayerGroupInfo.Mode.SINGLE);
        group.getLayers().add(layer);
        group.setTitle("This is the title");
        group.setAbstract("This is the abstract");
        group.setEnabled(false);
        this.getCatalog().add(group);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            PreviewLayer pl = this.getPreviewLayer(provider, group.prefixedName());
            Assert.assertNull((Object)pl);
        }
        finally {
            this.getCatalog().remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNotAdvertisedLayerGroup() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        LayerGroupInfo group = this.getCatalog().getFactory().createLayerGroup();
        group.setName("testSingleLayerGroup");
        group.setMode(LayerGroupInfo.Mode.SINGLE);
        group.getLayers().add(layer);
        group.setTitle("This is the title");
        group.setAbstract("This is the abstract");
        group.setAdvertised(false);
        this.getCatalog().add(group);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            PreviewLayer pl = this.getPreviewLayer(provider, group.prefixedName());
            Assert.assertNull((Object)pl);
        }
        finally {
            this.getCatalog().remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpaqueContainerLayerGroup() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        LayerGroupInfo group = this.getCatalog().getFactory().createLayerGroup();
        group.setName("testOpaqueContainerLayerGroup");
        group.setMode(LayerGroupInfo.Mode.OPAQUE_CONTAINER);
        group.getLayers().add(layer);
        group.setTitle("This is the title");
        group.setAbstract("This is the abstract");
        this.getCatalog().add(group);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            PreviewLayer pl = this.getPreviewLayer(provider, group.prefixedName());
            Assert.assertNotNull((Object)pl);
            Assert.assertEquals((Object)"This is the title", (Object)pl.getTitle());
            Assert.assertEquals((Object)"This is the abstract", (Object)pl.getAbstract());
        }
        finally {
            this.getCatalog().remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorkspacedLayerGroup() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        WorkspaceInfo ws = this.getCatalog().getWorkspaceByName("cite");
        LayerGroupInfo group = this.getCatalog().getFactory().createLayerGroup();
        group.setName("testWorkspacedLayerGroup");
        group.setMode(LayerGroupInfo.Mode.SINGLE);
        group.setWorkspace(ws);
        group.getLayers().add(layer);
        this.getCatalog().add(group);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            PreviewLayer pl = this.getPreviewLayer(provider, group.prefixedName());
            Assert.assertNotNull((Object)pl);
            Assert.assertEquals((Object)"cite:testWorkspacedLayerGroup", (Object)pl.getName());
        }
        finally {
            this.getCatalog().remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testContainerLayerGroup() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        LayerGroupInfo group = this.getCatalog().getFactory().createLayerGroup();
        group.setName("testContainerLayerGroup");
        group.setMode(LayerGroupInfo.Mode.CONTAINER);
        group.getLayers().add(layer);
        this.getCatalog().add(group);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            PreviewLayer pl = this.getPreviewLayer(provider, group.prefixedName());
            Assert.assertNull((Object)pl);
        }
        finally {
            this.getCatalog().remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedContainerLayerGroup() throws Exception {
        String layerId = this.getLayerId(MockData.BUILDINGS);
        LayerInfo layer = this.getCatalog().getLayerByName(layerId);
        LayerGroupInfo containerGroup = this.getCatalog().getFactory().createLayerGroup();
        containerGroup.setName("testContainerLayerGroup");
        containerGroup.setMode(LayerGroupInfo.Mode.SINGLE);
        containerGroup.getLayers().add(layer);
        this.getCatalog().add(containerGroup);
        LayerGroupInfo singleGroup = this.getCatalog().getFactory().createLayerGroup();
        singleGroup.setName("testSingleLayerGroup");
        singleGroup.setMode(LayerGroupInfo.Mode.SINGLE);
        singleGroup.getLayers().add(containerGroup);
        this.getCatalog().add(singleGroup);
        try {
            PreviewLayerProvider provider = new PreviewLayerProvider();
            Assert.assertNotNull((Object)this.getPreviewLayer(provider, singleGroup.prefixedName()));
            Assert.assertNotNull((Object)this.getPreviewLayer(provider, layer.prefixedName()));
        }
        finally {
            this.getCatalog().remove(singleGroup);
            this.getCatalog().remove(containerGroup);
        }
    }

    @Test
    public void testKewordsFilterSizeCache() {
        PreviewLayerProvider provider = new PreviewLayerProvider();
        Assert.assertEquals((long)29L, (long)provider.size());
        provider.setKeywords(new String[]{"cite"});
        Assert.assertEquals((long)12L, (long)provider.size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testGetItems() throws Exception {
        PreviewLayerProvider provider = new PreviewLayerProvider();
        provider.getItems();
    }

    private PreviewLayer getPreviewLayer(PreviewLayerProvider provider, String prefixedName) {
        for (PreviewLayer pl : Lists.newArrayList((Iterator)provider.iterator(0L, Integer.MAX_VALUE))) {
            if (!pl.getName().equals(prefixedName)) continue;
            return pl;
        }
        return null;
    }
}

