/* (c) 2014 - 2016 Open Source Geospatial Foundation - all rights reserved
 * (c) 2001 - 2013 OpenPlans
 * This code is licensed under the GPL 2.0 license, available at the root
 * application directory.
 */
package org.geoserver.web.demo;

import java.io.Serializable;

/**
 * Holds on the properties used as arguments for the Demo Request
 *
 * @author Gabriel Roldan (TOPP)
 * @version $Id$
 * @since 2.0.x
 */
public class DemoRequest implements Serializable {
    private static final long serialVersionUID = -6605104556907827822L;

    /** The directory containing the demo files */
    private final String demoDir;

    private String requestFileName;

    private String requestUrl;

    private String requestBody;

    private String userName;

    private String password;

    private boolean prettyXML = true;
    private boolean openNewWindow = false;

    public DemoRequest(final String demoDir) {
        this.demoDir = demoDir;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRequestFileName() {
        return requestFileName;
    }

    public void setRequestFileName(String requestFileName) {
        this.requestFileName = requestFileName;
    }

    public String getRequestUrl() {
        return requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getDemoDir() {
        return demoDir;
    }

    public boolean isPrettyXML() {
        return prettyXML;
    }

    public void setPrettyXML(boolean prettyXML) {
        this.prettyXML = prettyXML;
    }

    public boolean isOpenNewWindow() {
        return openNewWindow;
    }

    public void setOpenNewWindow(boolean openNewWindow) {
        this.openNewWindow = openNewWindow;
    }
}
