/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.web.demo.PreviewLayerModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;

public class PreviewLayerProvider
extends GeoServerDataProvider<PreviewLayer> {
    public static final long DEFAULT_CACHE_TIME = 1L;
    public static final String KEY_SIZE = "key.size";
    public static final String KEY_FULL_SIZE = "key.fullsize";
    private final Cache<String, Integer> cache;
    private SizeCallable sizeCaller;
    private FullSizeCallable fullSizeCaller;
    public static final GeoServerDataProvider.Property<PreviewLayer> TYPE = new GeoServerDataProvider.BeanProperty("type", "type");
    public static final GeoServerDataProvider.AbstractProperty<PreviewLayer> NAME = new GeoServerDataProvider.AbstractProperty<PreviewLayer>("name"){

        public Object getPropertyValue(PreviewLayer item) {
            if (item.layerInfo != null) {
                return item.layerInfo.prefixedName();
            }
            if (item.groupInfo != null) {
                return item.groupInfo.prefixedName();
            }
            return null;
        }
    };
    public static final GeoServerDataProvider.Property<PreviewLayer> TITLE = new GeoServerDataProvider.BeanProperty("title", "title");
    public static final GeoServerDataProvider.Property<PreviewLayer> ABSTRACT = new GeoServerDataProvider.BeanProperty("abstract", "abstract", false);
    public static final GeoServerDataProvider.Property<PreviewLayer> KEYWORDS = new GeoServerDataProvider.BeanProperty("keywords", "keywords", false);
    public static final GeoServerDataProvider.Property<PreviewLayer> COMMON = new GeoServerDataProvider.PropertyPlaceholder("commonFormats");
    public static final GeoServerDataProvider.Property<PreviewLayer> ALL = new GeoServerDataProvider.PropertyPlaceholder("allFormats");
    public static final List<GeoServerDataProvider.Property<PreviewLayer>> PROPERTIES = Arrays.asList(TYPE, TITLE, NAME, ABSTRACT, KEYWORDS, COMMON, ALL);

    public PreviewLayerProvider() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        this.cache = builder.expireAfterWrite(1L, TimeUnit.SECONDS).build();
        this.sizeCaller = new SizeCallable();
        this.fullSizeCaller = new FullSizeCallable();
    }

    protected List<PreviewLayer> getItems() {
        throw new UnsupportedOperationException("This method should not be being called! We use the catalog streaming API");
    }

    protected List<GeoServerDataProvider.Property<PreviewLayer>> getProperties() {
        return PROPERTIES;
    }

    protected IModel<PreviewLayer> newModel(PreviewLayer object) {
        return new PreviewLayerModel(object);
    }

    public long size() {
        try {
            if (this.getKeywords() != null && this.getKeywords().length > 0) {
                return ((Integer)this.cache.get((Object)("key.size." + String.join((CharSequence)",", this.getKeywords())), (Callable)this.sizeCaller)).intValue();
            }
            return ((Integer)this.cache.get((Object)KEY_SIZE, (Callable)this.sizeCaller)).intValue();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private int sizeInternal() {
        Filter filter = this.getFilter();
        int result = this.getCatalog().count(PublishedInfo.class, filter);
        return result;
    }

    public int fullSize() {
        try {
            return (Integer)this.cache.get((Object)KEY_FULL_SIZE, (Callable)this.fullSizeCaller);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private int fullSizeInternal() {
        Filter filter = Predicates.acceptAll();
        return this.getCatalog().count(PublishedInfo.class, filter);
    }

    public Iterator<PreviewLayer> iterator(long first, long count) {
        try (CloseableIterator<PreviewLayer> iterator = this.filteredItems(first, count);){
            Iterator<PreviewLayer> iterator2 = Lists.newArrayList(iterator).iterator();
            return iterator2;
        }
    }

    private CloseableIterator<PreviewLayer> filteredItems(long first, long count) {
        Catalog catalog = this.getCatalog();
        SortParam sort = this.getSort();
        GeoServerDataProvider.Property property = this.getProperty(sort);
        SortBy sortOrder = null;
        if (sort != null) {
            if (property instanceof GeoServerDataProvider.BeanProperty) {
                String sortProperty = ((GeoServerDataProvider.BeanProperty)property).getPropertyPath();
                sortOrder = Predicates.sortBy((String)sortProperty, (boolean)sort.isAscending());
            } else if (property == NAME) {
                sortOrder = Predicates.sortBy((String)"prefixedName", (boolean)sort.isAscending());
            }
        }
        Filter filter = this.getFilter();
        CloseableIterator pi = catalog.list(PublishedInfo.class, filter, Integer.valueOf((int)first), Integer.valueOf((int)count), sortOrder);
        return CloseableIteratorAdapter.transform((Iterator)pi, input -> {
            if (input instanceof LayerInfo) {
                return new PreviewLayer((LayerInfo)input);
            }
            if (input instanceof LayerGroupInfo) {
                return new PreviewLayer((LayerGroupInfo)input);
            }
            return null;
        });
    }

    protected Filter getFilter() {
        Filter filter = super.getFilter();
        Filter isLayerInfo = Predicates.isInstanceOf(LayerInfo.class);
        Filter isLayerGroupInfo = Predicates.isInstanceOf(LayerGroupInfo.class);
        Filter enabledFilter = Predicates.equal((String)"resource.enabled", (Object)true);
        Filter storeEnabledFilter = Predicates.equal((String)"resource.store.enabled", (Object)true);
        Filter advertisedFilter = Predicates.equal((String)"resource.advertised", (Object)true);
        Filter enabledLayerGroup = Predicates.equal((String)"enabled", (Object)true);
        Filter advertisedLayerGroup = Predicates.equal((String)"advertised", (Object)true);
        Filter nonContainerGroup = Predicates.or((Filter[])new Filter[]{Predicates.equal((String)"mode", (Object)LayerGroupInfo.Mode.EO), Predicates.equal((String)"mode", (Object)LayerGroupInfo.Mode.NAMED), Predicates.equal((String)"mode", (Object)LayerGroupInfo.Mode.OPAQUE_CONTAINER), Predicates.equal((String)"mode", (Object)LayerGroupInfo.Mode.SINGLE)});
        Filter layerFilter = Predicates.and((Filter[])new Filter[]{isLayerInfo, enabledFilter, storeEnabledFilter, advertisedFilter});
        Filter layerGroupFilter = Predicates.and((Filter[])new Filter[]{isLayerGroupInfo, nonContainerGroup, enabledLayerGroup, advertisedLayerGroup});
        Filter orFilter = Predicates.or((Filter)layerFilter, (Filter)layerGroupFilter);
        return Predicates.and((Filter)filter, (Filter)orFilter);
    }

    class FullSizeCallable
    implements Callable<Integer>,
    Serializable {
        FullSizeCallable() {
        }

        @Override
        public Integer call() throws Exception {
            return PreviewLayerProvider.this.fullSizeInternal();
        }
    }

    class SizeCallable
    implements Callable<Integer>,
    Serializable {
        SizeCallable() {
        }

        @Override
        public Integer call() throws Exception {
            return PreviewLayerProvider.this.sizeInternal();
        }
    }
}

