/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.web.demo.PreviewLayerProvider;
import org.junit.Assert;
import org.junit.Test;

public class PreviewLayerProviderMixedModeTest
extends GeoServerWicketTestSupport {
    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/web/demo/ResourceAccessManagerContext.xml");
    }

    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.addUser("cite", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        this.addUser("cite_mixed", "cite", null, Collections.singletonList("ROLE_DUMMY"));
        TestResourceAccessManager tam = (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo buildings = catalog.getFeatureTypeByName(this.getLayerId(SystemTestData.BUILDINGS));
        tam.putLimits("cite_mixed", (CatalogInfo)buildings, (AccessLimits)new VectorAccessLimits(CatalogMode.MIXED, null, (org.geotools.api.filter.Filter)org.geotools.api.filter.Filter.EXCLUDE, null, (org.geotools.api.filter.Filter)org.geotools.api.filter.Filter.EXCLUDE));
    }

    @Test
    public void testMixedMode() throws Exception {
        PreviewLayerProvider provider = new PreviewLayerProvider();
        this.login("cite", "cite", new String[0]);
        Assert.assertTrue((boolean)this.previewHasBuildings(provider));
        this.login("cite_mixed", "cite", new String[0]);
        Assert.assertFalse((boolean)this.previewHasBuildings(provider));
    }

    private boolean previewHasBuildings(PreviewLayerProvider provider) {
        Iterator it = provider.iterator(0L, provider.size());
        String buildingsPrefixedName = this.getLayerId(SystemTestData.BUILDINGS);
        while (it.hasNext()) {
            PreviewLayer pl = (PreviewLayer)it.next();
            if (!buildingsPrefixedName.equals(pl.getName())) continue;
            return true;
        }
        return false;
    }
}

