/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.platform.resource.Files;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.demo.DemoRequest;
import org.geoserver.web.demo.DemoRequestsPage;
import org.geotools.test.TestData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.util.SerializationUtils;

public class DemoRequestsPageTest
extends GeoServerWicketTestSupport {
    private File demoDir;

    @Before
    public void setUp() throws Exception {
        this.demoDir = TestData.file((Object)((Object)this), (String)"demo-requests");
        tester.startPage((Page)new DemoRequestsPage(Files.asResource((File)this.demoDir)));
    }

    @Test
    public void testStructure() {
        Assert.assertTrue((boolean)(tester.getLastRenderedPage() instanceof DemoRequestsPage));
        tester.assertComponent("demoRequestsForm", Form.class);
        tester.assertComponent("demoRequestsForm:demoRequestsList", DropDownChoice.class);
        tester.assertComponent("demoRequestsForm:url", TextField.class);
        tester.assertComponent("demoRequestsForm:body:editorContainer:editorParent:editor", TextArea.class);
        tester.assertComponent("demoRequestsForm:username", TextField.class);
        tester.assertComponent("demoRequestsForm:password", PasswordTextField.class);
    }

    @Test
    public void testPrettyXML() {
        FormTester requestFormTester = tester.newFormTester("demoRequestsForm");
        requestFormTester.select("demoRequestsList", 0);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
        DemoRequest model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertTrue((boolean)model.isPrettyXML());
        requestFormTester.setValue("prettyXML", false);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
        model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertFalse((boolean)model.isPrettyXML());
    }

    @Test
    public void testOpenNewPage() {
        FormTester requestFormTester = tester.newFormTester("demoRequestsForm");
        requestFormTester.select("demoRequestsList", 0);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
        DemoRequest model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertFalse((boolean)model.isOpenNewWindow());
        requestFormTester.setValue("openNewWindow", true);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
        model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertTrue((boolean)model.isOpenNewWindow());
    }

    @Test
    public void testPageParams() {
        PageParameters parameters = new PageParameters();
        parameters.add("url", (Object)"myurl");
        parameters.add("xml", (Object)"myxml");
        tester.startPage((Page)new DemoRequestsPage(Files.asResource((File)this.demoDir), parameters));
        DemoRequest model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertEquals((Object)"myurl", (Object)model.getRequestUrl());
        Assert.assertEquals((Object)"myxml", (Object)model.getRequestBody());
    }

    @Test
    public void testAuth() {
        FormTester requestFormTester = tester.newFormTester("demoRequestsForm");
        requestFormTester.setValue("username", "UserName");
        requestFormTester.setValue("password", "PassWord");
        requestFormTester.select("demoRequestsList", 0);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
        DemoRequest model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertEquals((Object)"UserName", (Object)model.getUserName());
        Assert.assertEquals((Object)"PassWord", (Object)model.getPassword());
        requestFormTester.setValue("username", "UserName2");
        requestFormTester.setValue("password", "PassWord2");
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
        model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertEquals((Object)"UserName2", (Object)model.getUserName());
        Assert.assertEquals((Object)"PassWord2", (Object)model.getPassword());
    }

    @Test
    public void testDropDownChanged() {
        FormTester requestFormTester = tester.newFormTester("demoRequestsForm");
        requestFormTester.select("demoRequestsList", 0);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
        DemoRequest model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertEquals((Object)"WFS_getFeature-1.1.xml", (Object)model.getRequestFileName());
        Assert.assertEquals((Object)"http://localhost/context/wfs", (Object)model.getRequestUrl());
        Assert.assertTrue((boolean)model.getRequestBody().startsWith("<!--"));
        requestFormTester.select("demoRequestsList", 1);
        tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
        model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
        Assert.assertEquals((Object)"WMS_describeLayer.url", (Object)model.getRequestFileName());
        Assert.assertEquals((Object)"http://localhost/context/wms?request=DescribeLayer&version=1.1.1&layers=topp:states\n", (Object)model.getRequestUrl());
        Assert.assertTrue((model.getRequestBody() == null || model.getRequestBody().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testDemoListLoaded() {
        List<String> expectedList = Arrays.asList("WFS_getFeature-1.1.xml", "WMS_describeLayer.url");
        DropDownChoice dropDown = (DropDownChoice)tester.getComponentFromLastRenderedPage("demoRequestsForm:demoRequestsList");
        List choices = dropDown.getChoices();
        Assert.assertEquals(expectedList, (Object)choices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyBaseUrl() {
        GeoServerInfo global = this.getGeoServer().getGlobal();
        String proxyBaseUrl = "http://www.geoserver.org/test_gs";
        global.getSettings().setProxyBaseUrl(proxyBaseUrl);
        try {
            this.getGeoServer().save(global);
            FormTester requestFormTester = tester.newFormTester("demoRequestsForm");
            String requestName = "WMS_describeLayer.url";
            requestFormTester.select("demoRequestsList", 1);
            tester.executeAjaxEvent("demoRequestsForm:demoRequestsList", "change");
            tester.assertModelValue("demoRequestsForm:demoRequestsList", (Object)"WMS_describeLayer.url");
            DemoRequest model = (DemoRequest)tester.getLastRenderedPage().getDefaultModel().getObject();
            String requestFileName = model.getRequestFileName();
            String requestUrl = model.getRequestUrl();
            Assert.assertEquals((Object)"WMS_describeLayer.url", (Object)requestFileName);
            Assert.assertTrue((boolean)requestUrl.startsWith(proxyBaseUrl + "/wms"));
        }
        finally {
            global.getSettings().setProxyBaseUrl(null);
            this.getGeoServer().save(global);
        }
    }

    @Test
    public void testSerializable() {
        DemoRequestsPage page = new DemoRequestsPage();
        DemoRequestsPage page2 = (DemoRequestsPage)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)page));
        Assert.assertEquals((Object)page.demoDir, (Object)page2.demoDir);
    }
}

