/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.config.GeoServer;
import org.geoserver.web.demo.CommonFormatLink;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.wfs.WFSInfo;

public class GMLFormatLink
extends CommonFormatLink {
    private GeoServer geoserver;
    private final transient Map<String, PreviewLayer.GMLOutputParams> gmlParamsCache = new HashMap<String, PreviewLayer.GMLOutputParams>();

    @Override
    public ExternalLink getFormatLink(PreviewLayer layer) {
        ExternalLink gmlLink = new ExternalLink(this.getComponentId(), layer.getGmlLink(this.gmlParamsCache) + this.getMaxFeatures(), new StringResourceModel(this.getTitleKey(), null, null).getString());
        gmlLink.setVisible(layer.getType() == PreviewLayer.PreviewLayerType.Vector && layer.hasServiceSupport("WFS"));
        return gmlLink;
    }

    private String getMaxFeatures() {
        WFSInfo service = (WFSInfo)this.geoserver.getService(WFSInfo.class);
        if (service.getMaxNumberOfFeaturesForPreview() > 0) {
            return "&maxFeatures=" + service.getMaxNumberOfFeaturesForPreview();
        }
        return "";
    }

    public void setGeoserver(GeoServer geoserver) {
        this.geoserver = geoserver;
    }
}

