/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.util.tester.TagTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.demo.MapPreviewPage;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.wfs.WFSInfo;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MapPreviewPageTest
extends GeoServerWicketTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setupIAULayers(true, true);
    }

    @Before
    public void setOutputPaths() {
        GeoServerApplication.get().getDebugSettings().setComponentPathAttributeName("wicketPath");
    }

    @Test
    public void testValues() throws Exception {
        tester.startPage(MapPreviewPage.class);
        tester.assertRenderedPage(MapPreviewPage.class);
    }

    @Test
    public void testLayerGroupNamesPrefixed() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo lg = cat.getFactory().createLayerGroup();
        lg.setName("foo");
        lg.setWorkspace(cat.getWorkspaceByName("sf"));
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.PRIMITIVEGEOFEATURE)));
        new CatalogBuilder(cat).calculateLayerGroupBounds(lg);
        cat.add(lg);
        tester.startPage(MapPreviewPage.class);
        tester.assertRenderedPage(MapPreviewPage.class);
        tester.clickLink("table:navigatorBottom:navigator:next", true);
        DataView data = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        boolean exists = false;
        for (Component datum : data) {
            MarkupContainer c = (MarkupContainer)datum;
            Label l = (Label)c.get("itemProperties:2:component");
            String model = l.getDefaultModelObjectAsString();
            if (!"sf:foo".equals(model)) continue;
            exists = true;
        }
        Assert.assertTrue((boolean)exists);
    }

    @Test
    @Ignore
    public void testLayerNamesPrefixed() throws Exception {
        Catalog cat = this.getCatalog();
        LayerInfo ly = cat.getLayerByName(this.getLayerId(MockData.STREAMS));
        Assert.assertNotNull((Object)ly);
        tester.startPage(MapPreviewPage.class);
        tester.assertRenderedPage(MapPreviewPage.class);
        tester.clickLink("table:navigatorBottom:navigator:next", true);
        DataView data = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
        boolean exists = false;
        for (Component datum : data) {
            MarkupContainer c = (MarkupContainer)datum;
            Label l = (Label)c.get("itemProperties:1:component");
            if (!this.getLayerId(MockData.STREAMS).equals(l.getDefaultModelObjectAsString())) continue;
            exists = true;
        }
        Assert.assertTrue((boolean)exists);
    }

    @Test
    public void testMaxNumberOfFeaturesForPreview() throws Exception {
        GeoServer geoserver = this.getGeoServer();
        WFSInfo wfsInfo = (WFSInfo)geoserver.getService(WFSInfo.class);
        int maxFeatures = 100;
        wfsInfo.setMaxNumberOfFeaturesForPreview(Integer.valueOf(maxFeatures));
        geoserver.save((ServiceInfo)wfsInfo);
        tester.startPage(MapPreviewPage.class);
        tester.assertRenderedPage(MapPreviewPage.class);
        this.assertMaxFeaturesInData(tester.getLastResponseAsString(), maxFeatures);
        maxFeatures = 0;
        wfsInfo.setMaxNumberOfFeaturesForPreview(Integer.valueOf(maxFeatures));
        geoserver.save((ServiceInfo)wfsInfo);
        tester.startPage(MapPreviewPage.class);
        tester.assertRenderedPage(MapPreviewPage.class);
        this.assertMaxFeaturesInData(tester.getLastResponseAsString(), maxFeatures);
    }

    private void assertMaxFeaturesInData(String html, int maxFeatures) {
        String PREFIX = "var maxFeature = '";
        String END = "';";
        if (maxFeatures > 0) {
            MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)(PREFIX + "&maxFeatures=" + maxFeatures + END)));
        } else {
            MatcherAssert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)(PREFIX + END)));
        }
    }

    @Test
    public void testWfsOutputFormatValueUrlEncoding() {
        tester.startPage(MapPreviewPage.class);
        tester.assertRenderedPage(MapPreviewPage.class);
        Label optionLabel = (Label)tester.getComponentFromLastRenderedPage("table:listContainer:items:4:itemProperties:4:component:menu:wfs:wfsFormats:3");
        Assert.assertEquals((Object)"GML3.2", (Object)optionLabel.getDefaultModelObjectAsString());
        for (Behavior b : optionLabel.getBehaviors()) {
            if (!(b instanceof AttributeModifier)) continue;
            AttributeModifier am = (AttributeModifier)b;
            String url = am.toString();
            Assert.assertFalse((boolean)url.contains("gml+xml"));
            Assert.assertTrue((boolean)url.contains("gml%2Bxml"));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNameURLEncoding() {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ft = catalog.getFeatureTypeByName("cite:Lakes");
        ft.setName("Lakes + a plus");
        catalog.save((ResourceInfo)ft);
        try {
            tester.startPage(MapPreviewPage.class);
            tester.assertRenderedPage(MapPreviewPage.class);
            DataView data = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
            boolean exists = false;
            String path = null;
            for (Component datum : data) {
                RepeatingView wfsFormats;
                MarkupContainer c = (MarkupContainer)datum;
                Label l = (Label)c.get("itemProperties:2:component");
                String model = l.getDefaultModelObjectAsString();
                if (!"cite:Lakes + a plus".equals(model)) continue;
                exists = true;
                path = c.getPageRelativePath();
                ExternalLink olLink = (ExternalLink)c.get("itemProperties:3:component:commonFormat:0").getDefaultModelObject();
                ExternalLink gmlLink = (ExternalLink)c.get("itemProperties:3:component:commonFormat:1").getDefaultModelObject();
                ExternalLink kmlLink = (ExternalLink)c.get("itemProperties:3:component:commonFormat:2").getDefaultModelObject();
                Assert.assertEquals((Object)"http://localhost/context/cite/wms?service=WMS&amp;version=1.1.0&amp;request=GetMap&amp;layers=cite%3ALakes%20%2B%20a%20plus&amp;bbox=-180.0%2C-90.0%2C180.0%2C90.0&amp;width=768&amp;height=384&amp;srs=EPSG%3A4326&amp;styles=&amp;format=application/openlayers", (Object)olLink.getDefaultModelObjectAsString());
                MatcherAssert.assertThat((Object)gmlLink.getDefaultModelObjectAsString(), (Matcher)CoreMatchers.containsString((String)"http://localhost/context/cite/ows?service=WFS&amp;version=1.0.0&amp;request=GetFeature&amp;typeName=cite%3ALakes%20%2B%20a%20plus"));
                Assert.assertEquals((Object)kmlLink.getDefaultModelObjectAsString(), (Object)"http://localhost/context/cite/wms/kml?layers=cite%3ALakes%20%2B%20a%20plus");
                RepeatingView wmsFormats = (RepeatingView)c.get("itemProperties:4:component:menu:wms:wmsFormats");
                if (wmsFormats != null) {
                    this.assertFormat(wmsFormats, "JPEG-PNG", true);
                }
                if ((wfsFormats = (RepeatingView)c.get("itemProperties:4:component:menu:wfs:wfsFormats")) == null) continue;
                this.assertFormat(wfsFormats, "CSV", true);
                this.assertFormat(wfsFormats, "text/csv", true);
            }
            Assert.assertTrue((String)"Could not find layer with expected name", (boolean)exists);
            String html = tester.getLastResponseAsString();
            TagTester menuTester = TagTester.createTagByAttribute((String)html, (String)"wicketPath", (String)(path.replace(":", "_") + "_itemProperties_4_component_menu"));
            MatcherAssert.assertThat((Object)menuTester.getAttribute("wmsLink"), (Matcher)CoreMatchers.containsString((String)"http://localhost/context/cite/wms?service=WMS&version=1.1.0&request=GetMap&layers=cite%3ALakes%20%2B%20a%20plus&bbox=-180.0%2C-90.0%2C180.0%2C90.0&width=768&height=384&srs=EPSG%3A4326&styles="));
            MatcherAssert.assertThat((Object)menuTester.getAttribute("wfsLink"), (Matcher)CoreMatchers.containsString((String)"http://localhost/context/cite/ows?service=WFS&version=1.0.0&request=GetFeature&typeName=cite%3ALakes%20%2B%20a%20plus"));
        }
        finally {
            ft.setName("Lines");
            catalog.save((ResourceInfo)ft);
        }
    }

    private void assertFormat(RepeatingView view, String format, boolean expected) {
        Boolean found = (Boolean)view.visitChildren(Label.class, (label, visit) -> {
            if (label.getDefaultModelObjectAsString().contains(format)) {
                visit.stop((Object)true);
            }
        });
        Assert.assertEquals((String)format, (Object)expected, (Object)(found == null ? false : found));
    }

    @Test
    public void testHasServiceSupport() throws Exception {
        Catalog cat = this.getCatalog();
        LayerGroupInfo lg = cat.getFactory().createLayerGroup();
        lg.setName("linkgroup");
        lg.setWorkspace(cat.getWorkspaceByName("sf"));
        lg.getLayers().add(cat.getLayerByName(this.getLayerId(MockData.PRIMITIVEGEOFEATURE)));
        new CatalogBuilder(cat).calculateLayerGroupBounds(lg);
        cat.add(lg);
        PreviewLayer layer = new PreviewLayer(lg);
        tester.startPage(MapPreviewPage.class);
        tester.assertRenderedPage(MapPreviewPage.class);
        Assert.assertTrue((boolean)layer.hasServiceSupport("WMS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarsPreview() throws Exception {
        Catalog cat = this.getCatalog();
        WorkspaceInfo ws = cat.getWorkspaceByName(SystemTestData.IAU_PREFIX);
        LocalWorkspace.set((WorkspaceInfo)ws);
        try {
            tester.startPage(MapPreviewPage.class);
            this.print((Component)tester.getLastRenderedPage(), true, true, true);
            DataView data = (DataView)tester.getComponentFromLastRenderedPage("table:listContainer:items");
            for (Component datum : data) {
                MarkupContainer c = (MarkupContainer)datum;
                ExternalLink link = (ExternalLink)c.get("itemProperties:3:component:commonFormat:0").getDefaultModelObject();
                String location = link.getDefaultModelObjectAsString();
                MatcherAssert.assertThat((Object)location, (Matcher)CoreMatchers.containsString((String)"srs=IAU%3A49900"));
            }
        }
        finally {
            LocalWorkspace.remove();
        }
    }
}

