/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.web.wicket.DecimalConverter;

public class DecimalListConverter
implements IConverter<List<Double>> {
    private DecimalConverter converter = new DecimalConverter();

    public List<Double> convertToObject(String value, Locale locale) throws ConversionException {
        ArrayList<Double> result = new ArrayList<Double>();
        if (value != null && !"-".equals(value.trim())) {
            String[] values;
            for (String s : values = value.split("\\s+")) {
                Double v = this.converter.convertToObject(s, locale);
                if (v == null) continue;
                result.add(v);
            }
        }
        return result;
    }

    public String convertToString(List<Double> value, Locale locale) {
        if (value == null || value.isEmpty()) {
            return "-";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.size(); ++i) {
            String str = this.converter.convertToString(value.get(i), locale);
            sb.append(str);
            if (i >= value.size() - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.converter.setMaximumFractionDigits(maximumFractionDigits);
    }
}

