/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;

public class DataDirectoryConverterLocator
implements IConverterLocator {
    static final Logger LOGGER = Logging.getLogger(DataDirectoryConverterLocator.class);
    GeoServerResourceLoader resourceLoader;

    public DataDirectoryConverterLocator(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (File.class.isAssignableFrom(type)) {
            return new FileLocator();
        }
        if (URL.class.isAssignableFrom(type)) {
            return new URLLocator();
        }
        if (URI.class.isAssignableFrom(type)) {
            return new URILocator();
        }
        return null;
    }

    File toFile(String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        try {
            try {
                URL url = new URL(value);
                if ("file".equals(url.getProtocol())) {
                    value = url.getFile();
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
            File file = new File(value);
            if (file.isAbsolute()) {
                return file;
            }
            return this.resourceLoader.find(value);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error converting \"" + value + "\" to File", e);
            return null;
        }
    }

    String fromFile(File file) {
        File data = this.resourceLoader.getBaseDirectory();
        ArrayList<String> path = new ArrayList<String>();
        boolean isChild = false;
        while (file != null) {
            if (file.equals(data)) {
                isChild = true;
                break;
            }
            path.add(file.getName());
            file = file.getParentFile();
        }
        if (isChild) {
            StringBuffer b = new StringBuffer("file:");
            for (int i = path.size() - 1; i > -1; --i) {
                b.append((String)path.get(i)).append(File.separatorChar);
            }
            b.setLength(b.length() - 1);
            return b.toString();
        }
        return null;
    }

    class URILocator
    implements IConverter<URI> {
        URILocator() {
        }

        public URI convertToObject(String value, Locale locale) {
            File file = DataDirectoryConverterLocator.this.toFile(value);
            if (file != null) {
                return file.toURI();
            }
            return null;
        }

        public String convertToString(URI value, Locale locale) {
            try {
                return new URLLocator().convertToString(value.toURL(), locale);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error converting \"" + value + "\" to URI", e);
                return null;
            }
        }
    }

    class URLLocator
    implements IConverter<URL> {
        URLLocator() {
        }

        public URL convertToObject(String value, Locale locale) {
            File file = DataDirectoryConverterLocator.this.toFile(value);
            if (file != null) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "Error converting \"" + value + "\" to URL", e);
                }
            }
            return null;
        }

        public String convertToString(URL value, Locale locale) {
            String file = value.getFile();
            if (file != null && !"".equals(file)) {
                return DataDirectoryConverterLocator.this.fromFile(new File(value.getFile()));
            }
            return null;
        }
    }

    class FileLocator
    implements IConverter<File> {
        FileLocator() {
        }

        public File convertToObject(String value, Locale locale) {
            return DataDirectoryConverterLocator.this.toFile(value);
        }

        public String convertToString(File value, Locale locale) {
            return DataDirectoryConverterLocator.this.fromFile(value);
        }
    }
}

