/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.geoserver.web.security.AccessDataRuleListView;
import org.geoserver.web.security.DataAccessRuleInfo;

public class AccessDataRulePanel
extends Panel {
    private static final long serialVersionUID = -5609090679199229976L;
    private IModel<List<DataAccessRuleInfo>> ownModel;
    private String workspaceName;
    private String layerName;
    private CatalogInfo info;
    private AccessDataRuleListView dataAccessView;
    WebMarkupContainer listContainer;

    public AccessDataRulePanel(String id, IModel<? extends CatalogInfo> model, IModel<List<DataAccessRuleInfo>> ownModel) {
        super(id, model);
        AccessDataRuleInfoManager manager = new AccessDataRuleInfoManager();
        this.info = (CatalogInfo)model.getObject();
        this.workspaceName = manager.getWorkspaceName(this.info);
        this.layerName = manager.getLayerName(this.info);
        this.ownModel = ownModel;
        this.listContainer = new WebMarkupContainer("listContainer");
        this.listContainer.setOutputMarkupId(true);
        boolean isWs = WorkspaceInfo.class.isAssignableFrom(((CatalogInfo)model.getObject()).getClass());
        this.dataAccessView = new AccessDataRuleListView("rules", ownModel, isWs);
        Label label = new Label("adminTh", (IModel)new ResourceModel("admin"));
        if (!isWs) {
            label.setVisible(false);
        }
        this.listContainer.add(new Component[]{label});
        this.listContainer.add(new Component[]{this.selectAllCheckbox()});
        this.dataAccessView.setOutputMarkupId(true);
        ownModel.setObject((Object)this.dataAccessView.getList());
        this.listContainer.add(new Component[]{this.dataAccessView});
        this.add(new Component[]{this.listContainer});
    }

    public void save() throws IOException {
        AccessDataRuleInfoManager manager = new AccessDataRuleInfoManager();
        Set<String> roles = manager.getAvailableRoles();
        Set<DataAccessRule> rules = manager.getResourceRule(this.workspaceName, this.info);
        boolean globalLayerGroup = this.info instanceof LayerGroupInfo && this.workspaceName == null;
        Set<DataAccessRule> news = manager.mapFrom((List)this.ownModel.getObject(), roles, this.workspaceName, this.layerName, globalLayerGroup);
        manager.saveRules(rules, news);
    }

    CheckBox selectAllCheckbox() {
        CheckBox sa = new CheckBox("selectAll", (IModel)new PropertyModel((Object)this, "dataAccessView.selectAll"));
        sa.setOutputMarkupId(true);
        sa.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){
            private static final long serialVersionUID = 1154921156065269691L;

            protected void onUpdate(AjaxRequestTarget target) {
                AccessDataRulePanel.this.dataAccessView.setSelection();
                target.add(new Component[]{this.getComponent()});
                target.add(new Component[]{AccessDataRulePanel.this.listContainer});
            }
        }});
        return sa;
    }
}

