/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.web.security.DataAccessRuleInfo;

public class AccessDataRuleListView
extends ListView<DataAccessRuleInfo> {
    private List<CheckBox> checkBoxes;
    private Boolean selectAll;
    private boolean isWs;

    public AccessDataRuleListView(String id, IModel<List<DataAccessRuleInfo>> model, boolean isWs) {
        super(id, model);
        this.isWs = isWs;
        if (this.checkBoxes == null) {
            int checkBoxesTypes = isWs ? 3 : 2;
            this.checkBoxes = new ArrayList<CheckBox>(((List)model.getObject()).size() * checkBoxesTypes);
        }
    }

    protected void populateItem(ListItem<DataAccessRuleInfo> item) {
        DataAccessRuleInfo ruleModel = (DataAccessRuleInfo)item.getModelObject();
        item.add(new Component[]{new Label("roleName", (IModel)new PropertyModel((Object)ruleModel, "roleName"))});
        CheckBox readCheckBox = new CheckBox("read", (IModel)new PropertyModel((Object)ruleModel, "read"));
        readCheckBox.setOutputMarkupId(true);
        item.add(new Component[]{readCheckBox});
        CheckBox writeCheckBox = new CheckBox("write", (IModel)new PropertyModel((Object)ruleModel, "write"));
        item.add(new Component[]{writeCheckBox});
        this.checkBoxes.add(readCheckBox);
        this.checkBoxes.add(writeCheckBox);
        CheckBox adminCheckBox = new CheckBox("admin", (IModel)new PropertyModel((Object)ruleModel, "admin"));
        adminCheckBox.setOutputMarkupId(true);
        if (!this.isWs) {
            adminCheckBox.setVisible(false);
        }
        item.add(new Component[]{adminCheckBox});
        this.checkBoxes.add(adminCheckBox);
        this.addNewCheckboxesUpdateBeahaviour();
        this.selectAll = this.checkAllSelected();
    }

    public List<CheckBox> getCheckBoxes() {
        return this.checkBoxes;
    }

    public void setCheckBoxes(List<CheckBox> checkBoxes) {
        this.checkBoxes = checkBoxes;
    }

    boolean checkAllSelected() {
        for (CheckBox c : this.checkBoxes) {
            if (((Boolean)c.getModelObject()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean getSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(Boolean selectAll) {
        this.selectAll = selectAll;
    }

    public void setSelection() {
        this.getCheckBoxes().forEach(c -> c.getModel().setObject((Object)this.selectAll));
        this.setSelectAll(this.selectAll);
    }

    private void addNewCheckboxesUpdateBeahaviour() {
        for (final CheckBox c : this.checkBoxes) {
            c.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){
                private static final long serialVersionUID = 1154921156065269691L;

                protected void onUpdate(AjaxRequestTarget target) {
                    AccessDataRuleListView.this.selectAll = AccessDataRuleListView.this.checkAllSelected();
                    target.add(new Component[]{c.getForm()});
                }
            }});
        }
    }

    public boolean isWs() {
        return this.isWs;
    }

    public void setWs(boolean ws) {
        this.isWs = ws;
    }
}

