/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.util.Collections;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.store.StoreNameComparator;

public class StoresModel
extends LoadableDetachableModel<List<StoreInfo>> {
    protected IModel workspace;

    public StoresModel(IModel workspaceModel) {
        this.workspace = workspaceModel;
    }

    protected List<StoreInfo> load() {
        Catalog catalog = GeoServerApplication.get().getCatalog();
        WorkspaceInfo ws = (WorkspaceInfo)this.workspace.getObject();
        List stores = catalog.getStoresByWorkspace(ws, StoreInfo.class);
        Collections.sort(stores, new StoreNameComparator());
        return stores;
    }

    public void detach() {
        super.detach();
        if (this.workspace != null) {
            this.workspace.detach();
        }
    }
}

