/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;

public class StoreModel<T extends StoreInfo>
extends LoadableDetachableModel<T> {
    IModel workspace;
    String name;

    public StoreModel(T store) {
        super(store);
        this.setObject(store);
    }

    public void setObject(T object) {
        super.setObject(object);
        if (object != null) {
            this.workspace = new WorkspaceDetachableModel(object.getWorkspace());
            this.name = object.getName();
        } else {
            this.name = null;
        }
    }

    protected T load() {
        if (this.workspace == null) {
            return null;
        }
        if (this.name == null) {
            return null;
        }
        return (T)GeoServerApplication.get().getCatalog().getStoreByName((WorkspaceInfo)this.workspace.getObject(), this.name, StoreInfo.class);
    }
}

