/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.web.data.resource.DimensionEditor;
import org.geoserver.web.data.resource.MetadataMapValidator;
import org.geoserver.web.data.resource.VectorCustomDimensionsPanel;
import org.geoserver.web.publish.PublishedEditTabPanel;
import org.geoserver.web.util.MetadataMapModel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.logging.Logging;

public class ResourceDimensionsTabPanelInfo
extends PublishedEditTabPanel<LayerInfo>
implements MetadataMapValidator {
    private static final long serialVersionUID = 4702596541385329270L;
    static final Logger LOGGER = Logging.getLogger(ResourceDimensionsTabPanelInfo.class);

    public ResourceDimensionsTabPanelInfo(String id, IModel<LayerInfo> model) {
        super(id, model);
        LayerInfo layer = (LayerInfo)model.getObject();
        final ResourceInfo resource = layer.getResource();
        PropertyModel metadata = new PropertyModel(model, "resource.metadata");
        MetadataMapModel<DimensionInfo> time = new MetadataMapModel<DimensionInfo>((IModel<MetadataMap>)metadata, "time", DimensionInfo.class);
        if (time.getObject() == null) {
            time.setObject(new DimensionInfoImpl());
        }
        this.add(new Component[]{new DimensionEditor("time", (IModel<DimensionInfo>)time, resource, (Class<?>)Date.class, true, true)});
        MetadataMapModel<DimensionInfo> elevation = new MetadataMapModel<DimensionInfo>((IModel<MetadataMap>)metadata, "elevation", DimensionInfo.class);
        if (elevation.getObject() == null) {
            elevation.setObject(new DimensionInfoImpl());
        }
        this.add(new Component[]{new DimensionEditor("elevation", (IModel<DimensionInfo>)elevation, resource, (Class<?>)Number.class)});
        final ArrayList<RasterDimensionModel<DimensionInfo>> customDimensionModels = new ArrayList<RasterDimensionModel<DimensionInfo>>();
        if (resource instanceof CoverageInfo) {
            CoverageInfo ci = (CoverageInfo)resource;
            try {
                GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
                ReaderDimensionsAccessor ra = new ReaderDimensionsAccessor(reader);
                for (String domain : ra.getCustomDomains()) {
                    boolean hasResolution;
                    boolean hasRange;
                    RasterDimensionModel<DimensionInfo> mm = new RasterDimensionModel<DimensionInfo>((IModel<MetadataMap>)metadata, domain, DimensionInfo.class, hasRange = ra.hasRange(domain), hasResolution = ra.hasResolution(domain));
                    if (mm.getObject() == null) {
                        mm.setObject((DimensionInfo)new DimensionInfoImpl());
                    }
                    customDimensionModels.add(mm);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to access coverage reader custom dimensions", e);
            }
        }
        RefreshingView customDimensionsEditor = new RefreshingView("customDimensions"){

            protected Iterator getItemModels() {
                return customDimensionModels.iterator();
            }

            protected void populateItem(Item item) {
                RasterDimensionModel model = (RasterDimensionModel)item.getModel();
                ParamResourceModel customDimension = new ParamResourceModel("customDimension", (Component)ResourceDimensionsTabPanelInfo.this, new Object[0]);
                item.add(new Component[]{new Label("dimensionName", (Serializable)((Object)(customDimension.getString() + ": " + model.getExpression())))});
                DimensionEditor editor = new DimensionEditor("dimension", model, resource, (Class<?>)String.class);
                editor.disablePresentationMode(DimensionPresentation.CONTINUOUS_INTERVAL);
                if (!model.hasRange && !model.hasResolution) {
                    editor.disablePresentationMode(DimensionPresentation.DISCRETE_INTERVAL);
                }
                item.add(new Component[]{editor});
            }
        };
        this.add(new Component[]{customDimensionsEditor});
        customDimensionsEditor.setVisible(!customDimensionModels.isEmpty());
        this.buildVectorCustomDimensionsPanel(model, resource);
    }

    private void buildVectorCustomDimensionsPanel(IModel<LayerInfo> model, ResourceInfo resource) {
        Object vectorCustomDimPanel;
        if (resource instanceof FeatureTypeInfo) {
            PropertyModel typeInfoModel = new PropertyModel(model, "resource");
            vectorCustomDimPanel = new VectorCustomDimensionsPanel("vectorCustomDimPanel", (IModel<FeatureTypeInfo>)typeInfoModel);
        } else {
            vectorCustomDimPanel = new WebMarkupContainer("vectorCustomDimPanel");
            vectorCustomDimPanel.setVisible(false);
        }
        this.add(new Component[]{vectorCustomDimPanel});
    }

    @Override
    public void validate(MetadataMap map) {
        if (this.metadataContainsRepeatedDimension("time", map) || this.metadataContainsRepeatedDimension("elevation", map)) {
            throw new IllegalArgumentException("Repeated dimensions names not allowed.");
        }
    }

    private boolean metadataContainsRepeatedDimension(String name, MetadataMap map) {
        return this.isDimensionEnabled(name, map) && this.isDimensionEnabled("dim_" + name, map);
    }

    private boolean isDimensionEnabled(String name, MetadataMap map) {
        Serializable object = map.get((Object)name);
        if (object == null || !(object instanceof DimensionInfo)) {
            return false;
        }
        DimensionInfo info = (DimensionInfo)object;
        return info.isEnabled();
    }

    class RasterDimensionModel<T>
    extends MetadataMapModel<T> {
        private static final long serialVersionUID = 4734439907138483817L;
        boolean hasRange;
        boolean hasResolution;

        public RasterDimensionModel(IModel<MetadataMap> model, String expression, Class<T> target, boolean hasRange, boolean hasResolution) {
            super(model, expression, target);
        }

        @Override
        public T getObject() {
            return (T)((MetadataMap)this.model.getObject()).get("custom_dimension_" + this.expression, this.target);
        }

        @Override
        public void setObject(T object) {
            ((MetadataMap)this.model.getObject()).put("custom_dimension_" + this.expression, (Serializable)object);
        }
    }
}

