/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.web.ComponentInfo;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geotools.util.logging.Logging;

public class ResourceConfigurationPanelInfo
extends ComponentInfo<ResourceConfigurationPanel> {
    public static final long serialVersionUID = -1L;
    private static Logger LOGGER = Logging.getLogger((String)"org.geoserver.config");
    private List<String> myHandleableClasses;

    public void setSupportedTypes(List<String> classNames) {
        this.myHandleableClasses = classNames;
    }

    public List<String> getSupportedTypes() {
        return Collections.unmodifiableList(this.myHandleableClasses);
    }

    public boolean canHandle(Object obj) {
        if (this.myHandleableClasses == null) {
            return true;
        }
        for (String className : this.myHandleableClasses) {
            try {
                if (!Class.forName(className).isInstance(obj)) continue;
                return true;
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.severe("Couldn't find class " + className + "; please check your applicationContext.xml.");
            }
        }
        return false;
    }
}

