/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.layergroup.LayerInfoConverter;
import org.geoserver.web.data.layergroup.LayerListPanel;
import org.geoserver.web.data.layergroup.StyleInfoConverter;
import org.geoserver.web.wicket.GSModalWindow;
import org.geoserver.web.wicket.ParamResourceModel;

public class RootLayerEntryPanel
extends Panel {
    private static final long serialVersionUID = 3471204885852128002L;

    public RootLayerEntryPanel(String id, final WorkspaceInfo workspace, final IModel<LayerGroupInfo> model) {
        super(id);
        this.setOutputMarkupId(true);
        TextField<LayerInfo> rootLayerField = new TextField<LayerInfo>("rootLayer"){
            private static final long serialVersionUID = -8033503312874828019L;

            public <C> IConverter<C> getConverter(Class<C> type) {
                if (LayerInfo.class.isAssignableFrom(type)) {
                    return new LayerInfoConverter();
                }
                return super.getConverter(type);
            }
        };
        rootLayerField.setOutputMarkupId(true);
        rootLayerField.setRequired(true);
        this.add(new Component[]{rootLayerField});
        ArrayList<StyleInfo> globalStyles = new ArrayList<StyleInfo>();
        List allStyles = GeoServerApplication.get().getCatalog().getStyles();
        for (StyleInfo s : allStyles) {
            if (s.getWorkspace() != null) continue;
            globalStyles.add(s);
        }
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        styles.addAll(globalStyles);
        if (workspace != null) {
            styles.addAll(GeoServerApplication.get().getCatalog().getStylesByWorkspace(workspace));
        }
        DropDownChoice<StyleInfo> styleField = new DropDownChoice<StyleInfo>("rootLayerStyle", styles){
            private static final long serialVersionUID = 1190134258726393181L;

            public <C> IConverter<C> getConverter(Class<C> type) {
                if (StyleInfo.class.isAssignableFrom(type)) {
                    return new StyleInfoConverter();
                }
                return super.getConverter(type);
            }
        };
        styleField.setNullValid(true);
        this.add(new Component[]{styleField});
        final GSModalWindow popupWindow = new GSModalWindow("popup");
        this.add(new Component[]{popupWindow});
        this.add(new Component[]{new AjaxLink<Object>("add", (TextField)rootLayerField){
            private static final long serialVersionUID = 723787950130153037L;
            final /* synthetic */ TextField val$rootLayerField;
            {
                this.val$rootLayerField = textField;
                super(id);
            }

            public void onClick(AjaxRequestTarget target) {
                popupWindow.setInitialHeight(375);
                popupWindow.setInitialWidth(525);
                popupWindow.setTitle((IModel<String>)new ParamResourceModel("chooseLayer", (Component)this, new Object[0]));
                popupWindow.setContent((Component)new LayerListPanel(popupWindow.getContentId(), workspace){
                    private static final long serialVersionUID = -650599334132713975L;

                    @Override
                    protected void handleLayer(LayerInfo layer, AjaxRequestTarget target) {
                        popupWindow.close(target);
                        ((LayerGroupInfo)model.getObject()).setRootLayer(layer);
                        target.add(new Component[]{val$rootLayerField});
                    }
                });
                popupWindow.show(target);
            }
        }});
    }
}

