/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.io.Serializable;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.web.GeoServerApplication;

public class LayerGroupEntry
implements Serializable {
    private static final long serialVersionUID = -2212620293553872451L;
    String styleId;
    String layerGroupStyle;
    String layerId;
    String layerGroupId;

    public LayerGroupEntry(PublishedInfo layer, StyleInfo style) {
        this.setLayer(layer);
        this.setStyle(style);
    }

    public Type getType() {
        if (this.layerId == null && this.layerGroupId == null) {
            return Type.STYLE_GROUP;
        }
        if (this.layerGroupId != null) {
            return Type.LAYER_GROUP;
        }
        return Type.LAYER;
    }

    public StyleInfo getStyle() {
        Catalog catalog = GeoServerApplication.get().getCatalog();
        StyleInfo result = null;
        if (this.styleId != null) {
            result = catalog.getStyle(this.styleId);
        } else if (this.layerGroupStyle != null) {
            StyleInfoImpl lgStyleName = new StyleInfoImpl(catalog);
            lgStyleName.setName(this.layerGroupStyle);
            result = lgStyleName;
        }
        return result;
    }

    public boolean isDefaultStyle() {
        return this.styleId == null && this.layerGroupStyle == null;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        List styleList;
        if (this.getLayer() == null) {
            this.setStyle(this.getStyle());
        } else if (defaultStyle) {
            this.setStyle(null);
        } else if (this.getLayer() instanceof LayerInfo) {
            this.setStyle(((LayerInfo)this.getLayer()).getDefaultStyle());
        } else if (this.getLayer() instanceof LayerGroupInfo && (styleList = ((LayerGroupInfo)this.getLayer()).getLayerGroupStyles()) != null && !styleList.isEmpty()) {
            this.setStyle(((LayerGroupStyle)styleList.get(0)).getName());
        }
    }

    public void setStyle(StyleInfo style) {
        if (style == null) {
            this.styleId = null;
        } else if (this.layerGroupId != null) {
            this.layerGroupStyle = style.getName();
        } else {
            this.styleId = style.getId();
        }
    }

    public PublishedInfo getLayer() {
        if (this.layerGroupId != null) {
            return GeoServerApplication.get().getCatalog().getLayerGroup(this.layerGroupId);
        }
        if (this.layerId != null) {
            return GeoServerApplication.get().getCatalog().getLayer(this.layerId);
        }
        return null;
    }

    public void setLayer(PublishedInfo publishedInfo) {
        if (publishedInfo != null) {
            if (publishedInfo instanceof LayerGroupInfo) {
                this.layerGroupId = publishedInfo.getId();
            } else {
                this.layerId = publishedInfo.getId();
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.layerGroupId == null ? 0 : this.layerGroupId.hashCode());
        result = 31 * result + (this.layerId == null ? 0 : this.layerId.hashCode());
        result = 31 * result + (this.styleId == null ? 0 : this.styleId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayerGroupEntry other = (LayerGroupEntry)obj;
        if (this.layerGroupId == null ? other.layerGroupId != null : !this.layerGroupId.equals(other.layerGroupId)) {
            return false;
        }
        if (this.layerId == null ? other.layerId != null : !this.layerId.equals(other.layerId)) {
            return false;
        }
        return !(this.styleId == null ? other.styleId != null : !this.styleId.equals(other.styleId));
    }

    static enum Type {
        LAYER("Layer"),
        LAYER_GROUP("Layer Group"),
        STYLE_GROUP("Style Group");

        String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

