/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.layer.AttributeDescription;
import org.geoserver.web.data.layer.NewFeatureTypePage;
import org.geoserver.web.wicket.CRSPanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.locationtech.jts.geom.Geometry;

public class AttributeEditPage
extends GeoServerSecuredPage {
    AttributeDescription attribute;
    NewFeatureTypePage previousPage;
    WebMarkupContainer crsContainer;
    WebMarkupContainer sizeContainer;
    boolean newAttribute;
    private TextField<String> nameField;
    String size;
    private TextField<String> sizeField;
    private CRSPanel crsField;

    public AttributeEditPage(AttributeDescription attribute, NewFeatureTypePage previousPage) {
        this(attribute, previousPage, false);
    }

    AttributeEditPage(final AttributeDescription attribute, final NewFeatureTypePage previousPage, final boolean newAttribute) {
        this.previousPage = previousPage;
        this.newAttribute = newAttribute;
        this.attribute = attribute;
        this.size = String.valueOf(attribute.getSize());
        final Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)attribute));
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        Component[] componentArray = new Component[1];
        this.nameField = new TextField("name");
        componentArray[0] = this.nameField;
        form.add(componentArray);
        DropDownChoice binding = new DropDownChoice("binding", AttributeDescription.BINDINGS, (IChoiceRenderer)new BindingChoiceRenderer());
        binding.add(new Behavior[]{new AjaxFormSubmitBehavior("change"){

            protected void onError(AjaxRequestTarget target) {
                this.updateVisibility(target);
            }

            private void updateVisibility(AjaxRequestTarget target) {
                AttributeEditPage.this.sizeContainer.setVisible(String.class.equals(attribute.getBinding()));
                AttributeEditPage.this.crsContainer.setVisible(attribute.getBinding() != null && Geometry.class.isAssignableFrom(attribute.getBinding()));
                AttributeEditPage.this.addFeedbackPanels(target);
                target.add(new Component[]{form});
            }

            protected void onSubmit(AjaxRequestTarget target) {
                this.updateVisibility(target);
            }
        }});
        form.add(new Component[]{binding});
        form.add(new Component[]{new CheckBox("nullable")});
        this.sizeContainer = new WebMarkupContainer("sizeContainer");
        this.sizeContainer.setOutputMarkupId(true);
        form.add(new Component[]{this.sizeContainer});
        Component[] componentArray2 = new Component[1];
        this.sizeField = new TextField("size", (IModel)new PropertyModel((Object)this, "size"));
        componentArray2[0] = this.sizeField;
        this.sizeContainer.add(componentArray2);
        this.sizeContainer.setVisible(String.class.equals(attribute.getBinding()));
        this.crsContainer = new WebMarkupContainer("crsContainer");
        this.crsContainer.setOutputMarkupId(true);
        form.add(new Component[]{this.crsContainer});
        Component[] componentArray3 = new Component[1];
        this.crsField = new CRSPanel("crs");
        componentArray3[0] = this.crsField;
        this.crsContainer.add(componentArray3);
        this.crsContainer.setVisible(attribute.getBinding() != null && Geometry.class.isAssignableFrom(attribute.getBinding()));
        SubmitLink submit = new SubmitLink("save"){

            public void onSubmit() {
                if (AttributeEditPage.this.validate()) {
                    if (newAttribute) {
                        previousPage.attributesProvider.addNewAttribute(attribute);
                    }
                    this.setResponsePage((IRequestablePage)previousPage);
                }
            }
        };
        form.setDefaultButton((IFormSubmittingComponent)submit);
        form.add(new Component[]{submit});
        form.add(new Component[]{new Link<Void>("cancel"){

            public void onClick() {
                this.setResponsePage((IRequestablePage)previousPage);
            }
        }});
    }

    protected boolean validate() {
        boolean valid = true;
        if (this.attribute.getName() == null || this.attribute.getName().trim().equals("")) {
            this.nameField.error((IValidationError)new ValidationError().addKey("Required"));
            valid = false;
        }
        if (String.class.equals(this.attribute.getBinding())) {
            try {
                this.attribute.setSize(Integer.parseInt(this.size));
                if (this.attribute.getSize() <= 0) {
                    this.sizeField.error((Serializable)((Object)new ParamResourceModel("notPositive", (Component)this, new Object[0])));
                    valid = false;
                }
            }
            catch (Exception e) {
                this.sizeField.error((Serializable)((Object)new ParamResourceModel("notInteger", (Component)this, this.size)));
                valid = false;
            }
        }
        if (Geometry.class.isAssignableFrom(this.attribute.getBinding()) && this.attribute.getCrs() == null) {
            this.crsField.error((IValidationError)new ValidationError().addKey("Required"));
            valid = false;
        }
        return valid;
    }

    static class BindingChoiceRenderer
    extends ChoiceRenderer<Class<?>> {
        BindingChoiceRenderer() {
        }

        public Object getDisplayValue(Class<?> object) {
            return AttributeDescription.getLocalizedName(object);
        }

        public String getIdValue(Class<?> object, int index) {
            return object.getName();
        }
    }
}

