/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.NumberTextField;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.web.GeoServerSecuredPage;
import org.geotools.util.logging.Logging;

public class LogPage
extends GeoServerSecuredPage {
    static final Logger LOGGER = Logging.getLogger(LogPage.class);
    private static final long serialVersionUID = 4742103132576413211L;
    static final String LINES = "lines";
    int lines = 1000;
    File logFile;

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)"var textArea = document.getElementById('logs');textArea.scrollTop = textArea.scrollHeight;"));
    }

    public LogPage(PageParameters params) {
        Form form = new Form("form");
        this.add(new Component[]{form});
        String location = GeoServerExtensions.getProperty((String)"GEOSERVER_LOG_LOCATION");
        if (location == null) {
            location = this.getGeoServerApplication().getGeoServer().getLogging().getLocation();
        }
        if (location == null) {
            GeoServerResourceLoader loader = this.getGeoServerApplication().getResourceLoader();
            this.logFile = loader.get("logs").get("geoserver.log").file();
            location = this.logFile.getAbsolutePath();
        } else {
            this.logFile = new File(location);
            if (!this.logFile.isAbsolute()) {
                GeoServerDataDirectory dd = this.getGeoServerApplication().getBeanOfType(GeoServerDataDirectory.class);
                this.logFile = dd.get(new String[]{Paths.convert((String)this.logFile.getPath())}).file();
            }
        }
        if (!this.logFile.exists()) {
            this.error((Serializable)((Object)("Could not find the GeoServer log file: " + this.logFile.getAbsolutePath())));
        }
        try {
            if (params.getNamedKeys().contains(LINES) && params.get(LINES).toInt() > 0) {
                this.lines = params.get(LINES).toInt();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error parsing the lines parameter: ", params.get(LINES).toString());
        }
        form.add(new Component[]{new SubmitLink("refresh"){

            public void onSubmit() {
                this.setResponsePage(LogPage.class, new PageParameters().add(LogPage.LINES, (Object)LogPage.this.lines));
            }
        }});
        NumberTextField lines = new NumberTextField(LINES, (IModel)new PropertyModel((Object)this, LINES));
        lines.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(1)));
        form.add(new Component[]{lines});
        TextArea logs = new TextArea("logs", (IModel)new GSLogsModel());
        logs.setOutputMarkupId(true);
        logs.setMarkupId("logs");
        this.add(new Component[]{logs});
        this.add(new Component[]{new Link<Object>("download"){

            public void onClick() {
                FileResourceStream stream = new FileResourceStream(LogPage.this.logFile){

                    public String getContentType() {
                        return "text/plain";
                    }
                };
                ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler((IResourceStream)stream, "geoserver.log");
                handler.setContentDisposition(ContentDisposition.ATTACHMENT);
                RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)handler);
            }
        }});
    }

    public class GSLogsModel
    extends LoadableDetachableModel<String> {
        private static final long serialVersionUID = 3364442904754424569L;

        protected String load() {
            String string;
            LinkedList<String> lineList = new LinkedList<String>();
            if (!LogPage.this.logFile.exists()) {
                return "";
            }
            BufferedReader br = new BufferedReader(new FileReader(LogPage.this.logFile));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    lineList.addLast(line);
                    if (lineList.size() <= LogPage.this.lines) continue;
                    lineList.removeFirst();
                }
                StringBuilder result = new StringBuilder();
                for (String logLine : lineList) {
                    result.append(logLine).append("\n");
                }
                string = result.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Failed to load log file contents", e);
                    return e.getMessage();
                }
            }
            br.close();
            return string;
        }
    }
}

