/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.WicketTester;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoServerTablePanelTest {
    WicketTester tester;
    static final int TOTAL_ITEMS = 40;
    static final int DEFAULT_ITEMS_PER_PAGE = 25;

    @Before
    public void setUp() throws Exception {
        this.tester = new WicketTester();
    }

    @Test
    public void testBasicTable() throws Exception {
        this.tester.startPage((Page)new FormTestPage(id -> new IntegerTable(id, false)));
        this.tester.assertComponent("form:panel", IntegerTable.class);
        String firstLabelPath = "form:panel:listContainer:items:1:itemProperties:0:component";
        this.tester.assertComponent(firstLabelPath, Label.class);
        Assert.assertEquals((Object)0, (Object)this.tester.getComponentFromLastRenderedPage(firstLabelPath).getDefaultModelObject());
        DataView dv = (DataView)this.tester.getComponentFromLastRenderedPage("form:panel:listContainer:items");
        Assert.assertEquals((long)25L, (long)dv.size());
    }

    @Test
    public void testFullSelection() throws Exception {
        this.tester.startPage((Page)new FormTestPage(id -> new IntegerTable(id, true)));
        this.tester.assertComponent("form:panel", IntegerTable.class);
        IntegerTable table = (IntegerTable)this.tester.getComponentFromLastRenderedPage("form:panel");
        String selectAllPath = "form:panel:listContainer:selectAllContainer:selectAll";
        String selectFirstPath = "form:panel:listContainer:items:1:selectItemContainer:selectItem";
        this.tester.assertComponent(selectAllPath, CheckBox.class);
        this.tester.assertComponent(selectFirstPath, CheckBox.class);
        Assert.assertEquals((long)0L, (long)table.getSelection().size());
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("panel:listContainer:selectAllContainer:selectAll", "true");
        this.tester.executeAjaxEvent(selectAllPath, "click");
        Assert.assertEquals((long)25L, (long)table.getSelection().size());
        Assert.assertEquals((Object)0, table.getSelection().get(0));
        table.setSelection(false);
        Assert.assertEquals((long)0L, (long)table.getSelection().size());
    }

    @Test
    public void testSingleSelection() throws Exception {
        this.tester.startPage((Page)new FormTestPage(id -> new IntegerTable(id, true)));
        this.tester.assertComponent("form:panel", IntegerTable.class);
        IntegerTable table = (IntegerTable)this.tester.getComponentFromLastRenderedPage("form:panel");
        Assert.assertEquals((long)0L, (long)table.getSelection().size());
        FormTester ft = this.tester.newFormTester("form");
        ft.setValue("panel:listContainer:items:1:selectItemContainer:selectItem", "true");
        ft.setValue("panel:listContainer:items:7:selectItemContainer:selectItem", "true");
        ft.submit();
        Assert.assertEquals((long)2L, (long)table.getSelection().size());
        Assert.assertEquals((Object)0, table.getSelection().get(0));
        Assert.assertEquals((Object)6, table.getSelection().get(1));
    }

    @Test
    public void testSingleSelectionByObjectAndIndex() throws Exception {
        this.tester.startPage((Page)new FormTestPage(id -> new IntegerTable(id, true)));
        this.tester.assertComponent("form:panel", IntegerTable.class);
        IntegerTable table = (IntegerTable)this.tester.getComponentFromLastRenderedPage("form:panel");
        Assert.assertEquals((long)0L, (long)table.getSelection().size());
        table.selectObject(5);
        Assert.assertEquals((long)1L, (long)table.getSelection().size());
        Assert.assertEquals((Object)5, table.getSelection().get(0));
        table.selectObject(7);
        Assert.assertEquals((long)2L, (long)table.getSelection().size());
        Assert.assertEquals((Object)5, table.getSelection().get(0));
        Assert.assertEquals((Object)7, table.getSelection().get(1));
    }

    @Test
    public void testFilter() {
        this.tester.startPage((Page)new FormTestPage(id -> new IntegerTable(id, true)));
        this.tester.assertComponent("form:panel", IntegerTable.class);
        DataView dv = (DataView)this.tester.getComponentFromLastRenderedPage("form:panel:listContainer:items");
        Assert.assertEquals((long)25L, (long)dv.size());
        String filterLabelPath = "form:panel:filterForm:navigatorTop:filterMatch";
        this.tester.assertComponent(filterLabelPath, Label.class);
        this.tester.assertLabel(filterLabelPath, "1 -&gt; 25 of 40");
        FormTester ft = this.tester.newFormTester("form:panel:filterForm");
        ft.setValue("filter", "5");
        ft.submit("submit");
        dv = (DataView)this.tester.getComponentFromLastRenderedPage("form:panel:listContainer:items");
        Assert.assertEquals((long)4L, (long)dv.size());
        this.tester.assertLabel("form:panel:filterForm:navigatorTop:filterMatch", "1 -&gt; 4 of 4/40");
        this.tester.assertVisible("form:panel:filterForm:clear");
        this.tester.clickLink("form:panel:filterForm:clear", true);
        this.tester.assertInvisible("form:panel:filterForm:clear");
        this.tester.assertModelValue("form:panel:filterForm:filter", (Object)"");
        dv = (DataView)this.tester.getComponentFromLastRenderedPage("form:panel:listContainer:items");
        Assert.assertEquals((long)25L, (long)dv.size());
    }

    static class IntegerProvider
    extends GeoServerDataProvider<Integer> {
        static final GeoServerDataProvider.Property<Integer> IDX = new GeoServerDataProvider.Property<Integer>(){

            public String getName() {
                return "idx";
            }

            public Object getPropertyValue(Integer item) {
                return item;
            }

            public IModel<?> getModel(IModel<Integer> itemModel) {
                return null;
            }

            public Comparator<Integer> getComparator() {
                return null;
            }

            public boolean isVisible() {
                return true;
            }

            public boolean isSearchable() {
                return true;
            }
        };

        IntegerProvider() {
        }

        protected List<Integer> getItems() {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = 0; i < 40; ++i) {
                result.add(i);
            }
            return result;
        }

        protected List<GeoServerDataProvider.Property<Integer>> getProperties() {
            return Collections.singletonList(IDX);
        }
    }

    static class IntegerTable
    extends GeoServerTablePanel<Integer> {
        public IntegerTable(String id, boolean selectable) {
            super(id, (GeoServerDataProvider)new IntegerProvider(), selectable);
        }

        protected Component getComponentForProperty(String id, IModel<Integer> itemModel, GeoServerDataProvider.Property<Integer> property) {
            if (property == IntegerProvider.IDX) {
                return new Label(id, itemModel);
            }
            return null;
        }

        protected IModel<String> getPropertyTitle(GeoServerDataProvider.Property<Integer> property) {
            return new Model((Serializable)((Object)property.getName()));
        }

        IModel<String> showingAllRecords(long first, long last, long size) {
            return new Model((Serializable)((Object)(first + " -> " + last + " of " + size)));
        }

        IModel<String> matchedXOutOfY(long first, long last, long size, long fullSize) {
            return new Model((Serializable)((Object)(first + " -> " + last + " of " + size + "/" + fullSize)));
        }
    }
}

