/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.table;

import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.layer.NewLayerPageProvider;
import org.junit.Assert;
import org.junit.Test;

public class NewLayerProviderTest
extends GeoServerWicketTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    @Test
    public void testFeatureType() {
        StoreInfo cite = this.getCatalog().getStoreByName(MockData.CITE_PREFIX, StoreInfo.class);
        NewLayerPageProvider provider = new NewLayerPageProvider();
        provider.setStoreId(cite.getId());
        provider.setShowPublished(true);
        Assert.assertTrue((provider.size() > 0L ? 1 : 0) != 0);
        provider.setShowPublished(false);
        Assert.assertEquals((long)0L, (long)provider.size());
    }

    @Test
    public void testCoverages() {
        StoreInfo dem = this.getCatalog().getStoreByName(MockData.TASMANIA_DEM.getLocalPart(), StoreInfo.class);
        NewLayerPageProvider provider = new NewLayerPageProvider();
        provider.setStoreId(dem.getId());
        provider.setShowPublished(true);
        Assert.assertTrue((provider.size() > 0L ? 1 : 0) != 0);
        provider.setShowPublished(false);
    }

    @Test
    public void testEmpty() {
        NewLayerPageProvider provider = new NewLayerPageProvider();
        provider.setShowPublished(true);
        Assert.assertEquals((long)0L, (long)provider.size());
        provider.setShowPublished(false);
        Assert.assertEquals((long)0L, (long)provider.size());
    }

    @Test
    public void testPublishedUnpublishedWithChangedResourceName() {
        Catalog catalog = this.getCatalog();
        StoreInfo cite = catalog.getStoreByName(MockData.CITE_PREFIX, StoreInfo.class);
        List resources = catalog.getResourcesByStore(cite, FeatureTypeInfo.class);
        Assert.assertFalse((boolean)resources.isEmpty());
        int numberOfPublishedResources = resources.size();
        NewLayerPageProvider provider = new NewLayerPageProvider();
        provider.setStoreId(cite.getId());
        provider.setShowPublished(false);
        Assert.assertEquals((long)0L, (long)provider.size());
        provider.setShowPublished(true);
        Assert.assertEquals((long)numberOfPublishedResources, (long)provider.size());
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)resources.get(0);
        typeInfo.setName("notTheNativeName");
        catalog.save((ResourceInfo)typeInfo);
        provider = new NewLayerPageProvider();
        provider.setStoreId(cite.getId());
        provider.setShowPublished(true);
        Assert.assertEquals((long)numberOfPublishedResources, (long)provider.size());
        provider.setShowPublished(false);
        Assert.assertEquals((long)0L, (long)provider.size());
    }
}

