/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geoserver.security.impl.FileSandboxEnforcer;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.store.DataAccessEditPage;
import org.geoserver.web.data.store.StorePage;
import org.geoserver.web.data.store.panel.DropDownChoiceParamPanel;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.postgresql.jdbc.SslMode;
import org.springframework.context.ApplicationContext;

public class DataAccessEditPageTest
extends GeoServerWicketTestSupport {
    private static final String ROLE_CITE = "ROLE_CITE";
    private DataStoreInfo store;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        GeoServerExtensions.bean(FileSandboxEnforcer.class, (ApplicationContext)applicationContext);
    }

    @Before
    public void init() {
        Catalog cat;
        DataStoreInfo ds;
        this.login();
        DataStoreInfo dataStore = this.getCatalog().getDataStoreByName(MockData.CITE_PREFIX);
        if (dataStore == null && (ds = (cat = this.getCatalog()).getDataStoreByName("citeModified")) != null) {
            ds.setName(MockData.CITE_PREFIX);
            cat.save((StoreInfo)ds);
        }
        this.store = (DataStoreInfo)this.getCatalog().getStoreByName(MockData.CITE_PREFIX, DataStoreInfo.class);
        tester.startPage((Page)new DataAccessEditPage(this.store.getId()));
    }

    @Test
    public void testLoad() throws IOException {
        tester.assertRenderedPage(DataAccessEditPage.class);
        tester.assertNoErrorMessage();
        this.print((Component)tester.getLastRenderedPage(), true, true);
        tester.assertLabel("dataStoreForm:storeType", "Properties");
        tester.assertModelValue("dataStoreForm:dataStoreNamePanel:border:border_body:paramValue", (Object)"cite");
        String expectedPath = new org.apache.wicket.util.file.File(((SystemTestData)this.getTestData()).getDataDirectoryRoot(), "cite").getCanonicalPath();
        tester.assertModelValue("dataStoreForm:parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue", (Object)expectedPath);
    }

    @Test
    public void testEditName() {
        FormTester form = tester.newFormTester("dataStoreForm");
        form.setValue("dataStoreNamePanel:border:border_body:paramValue", "citeModified");
        form.submit();
        tester.assertNoErrorMessage();
        tester.clickLink("dataStoreForm:save");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(StorePage.class);
        Assert.assertNotNull((Object)this.getCatalog().getDataStoreByName("citeModified"));
    }

    @Test
    public void testEditNameApply() {
        FormTester form = tester.newFormTester("dataStoreForm");
        form.setValue("dataStoreNamePanel:border:border_body:paramValue", "citeModified");
        form.submit();
        tester.assertNoErrorMessage();
        tester.clickLink("dataStoreForm:apply");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(DataAccessEditPage.class);
        Assert.assertNotNull((Object)this.getCatalog().getDataStoreByName("citeModified"));
    }

    @Test
    public void testNameRequired() {
        FormTester form = tester.newFormTester("dataStoreForm");
        form.setValue("dataStoreNamePanel:border:border_body:paramValue", null);
        form.setValue("workspacePanel:border:border_body:paramValue", "cite");
        form.submit();
        tester.debugComponentTrees();
        tester.assertRenderedPage(DataAccessEditPage.class);
        List l = Lists.transform((List)tester.getMessages(400), input -> input.toString());
        Assert.assertTrue((boolean)l.contains("Field 'Data Source Name' is required."));
    }

    @Test
    @Ignore
    public void testWorkspaceSyncsUpWithNamespace() {
        FormTester formTester = tester.newFormTester("dataStoreForm");
        this.print((Component)tester.getLastRenderedPage(), true, true);
        String wsDropdownPath = "dataStoreForm:workspacePanel:border:border_body:paramValue";
        String namespaceParamPath = "dataStoreForm:parametersPanel:parameters:1:parameterPanel:paramValue";
        String directoryParamPath = "dataStoreForm:parametersPanel:parameters:0:parameterPanel:border:border_body:paramValue";
        Catalog catalog = this.getCatalog();
        tester.assertModelValue("dataStoreForm:workspacePanel:border:border_body:paramValue", (Object)catalog.getWorkspaceByName(MockData.CITE_PREFIX));
        tester.assertModelValue("dataStoreForm:parametersPanel:parameters:1:parameterPanel:paramValue", (Object)catalog.getNamespaceByPrefix(MockData.CITE_PREFIX).getURI());
        Serializable directory = (Serializable)this.store.getConnectionParameters().get("directory");
        tester.assertModelValue("dataStoreForm:parametersPanel:parameters:0:parameterPanel:border:border_body:paramValue", (Object)directory);
        WorkspaceInfo expectedWorkspace = catalog.getWorkspaceByName(MockData.CDF_PREFIX);
        NamespaceInfo expectedNamespace = catalog.getNamespaceByPrefix(MockData.CDF_PREFIX);
        formTester.select("workspacePanel:border:border_body:paramValue", 4);
        Component wsDropDown = tester.getComponentFromLastRenderedPage("dataStoreForm:workspacePanel:border:border_body:paramValue");
        tester.executeAjaxEvent(wsDropDown, "change");
        tester.assertModelValue("dataStoreForm:workspacePanel:border:border_body:paramValue", (Object)expectedWorkspace);
        tester.assertModelValue("dataStoreForm:parametersPanel:parameters:1:parameterPanel:paramValue", (Object)expectedNamespace.getURI());
        tester.assertModelValue("dataStoreForm:parametersPanel:parameters:0:parameterPanel:border:border_body:paramValue", (Object)directory);
        boolean isAjax = true;
        tester.clickLink("dataStoreForm:save", true);
        tester.assertRenderedPage(StorePage.class);
        DataStoreInfo dataStore = catalog.getDataStore(this.store.getId());
        Serializable namespace = (Serializable)dataStore.getConnectionParameters().get("namespace");
        Assert.assertEquals((Object)expectedNamespace.getURI(), (Object)namespace);
        List resourcesByStore = catalog.getResourcesByStore((StoreInfo)dataStore, FeatureTypeInfo.class);
        for (FeatureTypeInfo ft : resourcesByStore) {
            Assert.assertEquals((String)("Namespace for " + ft.getName() + " was not updated"), (Object)expectedNamespace, (Object)ft.getNamespace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditDettached() throws Exception {
        Catalog catalog = this.getCatalog();
        DataStoreInfo ds = catalog.getFactory().createDataStore();
        new CatalogBuilder(catalog).updateDataStore(ds, this.store);
        Assert.assertNull((Object)ds.getId());
        try {
            tester.startPage((Page)new DataAccessEditPage(ds));
            tester.assertNoErrorMessage();
            FormTester form = tester.newFormTester("dataStoreForm");
            form.select("workspacePanel:border:border_body:paramValue", 4);
            Component wsDropDown = tester.getComponentFromLastRenderedPage("dataStoreForm:workspacePanel:border:border_body:paramValue");
            tester.executeAjaxEvent(wsDropDown, "change");
            form.setValue("dataStoreNamePanel:border:border_body:paramValue", "foo");
            form.setValue("parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue", "/foo");
            tester.clickLink("dataStoreForm:save", true);
            tester.assertNoErrorMessage();
            catalog.save((StoreInfo)ds);
            Assert.assertNotNull((Object)ds.getId());
            Assert.assertEquals((Object)"foo", (Object)ds.getName());
        }
        finally {
            catalog.remove((StoreInfo)ds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataStoreEdit() throws Exception {
        Catalog catalog = this.getCatalog();
        DataStoreInfo ds = catalog.getFactory().createDataStore();
        new CatalogBuilder(catalog).updateDataStore(ds, this.store);
        Assert.assertNull((Object)ds.getId());
        try {
            tester.startPage((Page)new DataAccessEditPage(ds));
            tester.assertNoErrorMessage();
            FormTester form = tester.newFormTester("dataStoreForm");
            form.select("workspacePanel:border:border_body:paramValue", 4);
            Component wsDropDown = tester.getComponentFromLastRenderedPage("dataStoreForm:workspacePanel:border:border_body:paramValue");
            tester.executeAjaxEvent(wsDropDown, "change");
            form.setValue("dataStoreNamePanel:border:border_body:paramValue", "foo");
            form.setValue("parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue", "/foo");
            tester.clickLink("dataStoreForm:save", true);
            tester.assertNoErrorMessage();
            catalog.save((StoreInfo)ds);
            Assert.assertNotNull((Object)ds.getId());
            DataStoreInfo expandedStore = catalog.getResourcePool().clone(ds, true);
            Assert.assertNotNull((Object)expandedStore.getId());
            Assert.assertNotNull((Object)expandedStore.getCatalog());
            catalog.validate((StoreInfo)expandedStore, false).throwIfInvalid();
        }
        finally {
            catalog.remove((StoreInfo)ds);
        }
    }

    @Test
    public void testDataStoreEditEnum() throws Exception {
        Catalog catalog = this.getCatalog();
        DataStoreInfo ds = catalog.getFactory().createDataStore();
        ds.setType("PostGIS");
        ds.getConnectionParameters().put(PostgisNGDataStoreFactory.SSL_MODE.key, "DISABLE");
        new CatalogBuilder(catalog).updateDataStore(ds, this.store);
        Assert.assertNull((Object)ds.getId());
        tester.startPage((Page)new DataAccessEditPage(ds));
        tester.assertNoErrorMessage();
        this.print((Component)tester.getLastRenderedPage(), true, true);
        MarkupContainer container = (MarkupContainer)tester.getLastRenderedPage().get("dataStoreForm:parametersPanel:parameters");
        DropDownChoiceParamPanel dropDown = null;
        for (Component component : container) {
            DropDownChoiceParamPanel panel;
            if (!(component instanceof ListItem) || !(component.get("parameterPanel") instanceof DropDownChoiceParamPanel) || (panel = (DropDownChoiceParamPanel)component.get("parameterPanel")).getDefaultModelObject() != SslMode.DISABLE) continue;
            dropDown = panel;
        }
        Assert.assertNotNull(dropDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataStoreEditSandbox() throws Exception {
        File sandbox = new File("./target/sandbox").getCanonicalFile();
        File citeFolder = new File(sandbox, MockData.CITE_PREFIX);
        File toppFolder = new File(sandbox, "topp");
        citeFolder.mkdirs();
        toppFolder.mkdirs();
        Resource layerSecurity = this.getDataDirectory().get(new String[]{"security/layers.properties"});
        Properties properties = new Properties();
        properties.put("filesystemSandbox", sandbox.getAbsolutePath());
        properties.put("cite.*.a", ROLE_CITE);
        try (OutputStream os = layerSecurity.out();){
            properties.store(os, "sandbox");
        }
        DefaultFileAccessManager fam = (DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class, (ApplicationContext)applicationContext);
        fam.reload();
        this.login("cite", "pwd", new String[]{ROLE_CITE});
        try {
            tester.startPage((Page)new DataAccessEditPage(this.store.getId()));
            FormTester form = tester.newFormTester("dataStoreForm");
            String toppPath = toppFolder.getAbsolutePath();
            String fileInputPath = "parametersPanel:parameters:0:parameterPanel:fileInput:border:border_body:paramValue";
            form.setValue(fileInputPath, toppPath);
            form.submit();
            tester.clickLink("dataStoreForm:save", true);
            List messages = tester.getMessages(400);
            Assert.assertEquals((long)1L, (long)messages.size());
            DataAccessEditPageTest.checkSandboxDeniedMessage(((Serializable)messages.get(0)).toString(), toppPath);
            tester.clearFeedbackMessages();
            DataAccessEditPageTest.checkSandboxDeniedMessage(tester.getLastResponseAsString(), toppPath);
            form = tester.newFormTester("dataStoreForm");
            String citePath = citeFolder.getAbsolutePath();
            form.setValue(fileInputPath, citePath);
            form.submit();
            tester.clickLink("dataStoreForm:save", true);
            tester.assertNoErrorMessage();
            DataStoreInfo store = this.getCatalog().getDataStoreByName(MockData.CITE_PREFIX);
            Assert.assertEquals((Object)("file://" + citePath.replace("\\", "/")), store.getConnectionParameters().get("directory"));
        }
        finally {
            layerSecurity.delete();
            fam.reload();
        }
    }

    private static void checkSandboxDeniedMessage(String message, String toppPath) {
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Access to "), (Matcher)Matchers.containsString((String)toppPath), (Matcher)Matchers.containsString((String)" denied by file sandboxing")));
    }
}

