/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.wicket.Component;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.resource.VectorCustomDimensionEditor;
import org.geoserver.web.data.resource.VectorCustomDimensionEntry;
import org.junit.Assert;
import org.junit.Test;

public class VectorCustomDimensionEditorTest
extends GeoServerWicketTestSupport {
    private static final String markup = "<form wicket:id=\"form\"><div wicket:id=\"dimEditor\" /></form>";

    @Test
    public void testEditor() {
        Catalog catalog = this.getCatalog();
        LayerInfo layerInfo = catalog.getLayerByName("RoadSegments");
        Assert.assertTrue((boolean)(layerInfo.getResource() instanceof FeatureTypeInfo));
        FeatureTypeInfo featureTypeInfo = (FeatureTypeInfo)layerInfo.getResource();
        MetadataMap metadataMap = featureTypeInfo.getMetadata();
        DimensionInfoImpl dimension = new DimensionInfoImpl();
        dimension.setEnabled(true);
        dimension.setAttribute("name");
        dimension.setPresentation(DimensionPresentation.LIST);
        metadataMap.put("dim_name", (Serializable)dimension);
        catalog.save((ResourceInfo)featureTypeInfo);
        Pair entry = Pair.of((Object)"dim_name", (Object)dimension);
        VectorCustomDimensionEntry dimEntry = new VectorCustomDimensionEntry((Map.Entry)entry);
        VectorCustomDimensionEditor editor = new VectorCustomDimensionEditor("dimEditor", (IModel)Model.of((Serializable)dimEntry), (ResourceInfo)featureTypeInfo, Serializable.class);
        Form form = new Form("form");
        form.add(new Component[]{editor});
        form = (Form)tester.startComponentInPage((Component)form, (IMarkupFragment)Markup.of((String)markup));
        TextField dimNameInput = (TextField)tester.getComponentFromLastRenderedPage("form:dimEditor:customDimName");
        Assert.assertEquals((Object)"name", (Object)dimNameInput.getModelObject());
    }
}

