/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.CoverageView;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.layer.CoverageViewEditor;
import org.geoserver.web.data.layer.CoverageViewNewPage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class CoverageViewEditorTest
extends GeoServerWicketTestSupport {
    private static QName TIME_RANGES = new QName(MockData.DEFAULT_URI, "timeranges", MockData.DEFAULT_PREFIX);
    private static QName S2MASK = new QName(MockData.WCS_URI, "s2mask", MockData.WCS_PREFIX);

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addRasterLayer(TIME_RANGES, "timeranges.zip", null, null, SystemTestData.class, this.getCatalog());
        testData.addDefaultRasterLayer(SystemTestData.TASMANIA_BM, this.getCatalog());
        testData.addRasterLayer(S2MASK, "s2mask.zip", null, null, SystemTestData.class, this.getCatalog());
    }

    @Test
    public void testSingleBandsIndexIsNotVisible() throws Exception {
        this.login();
        CoverageViewNewPage newPage = new CoverageViewNewPage(MockData.DEFAULT_PREFIX, "timeranges", null, null);
        tester.startPage((Page)newPage);
        tester.assertComponent("form:coverages:bandChoiceContainer:outputBandsChoice", ListMultipleChoice.class);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:name", TextField.class);
        tester.assertComponent("form:coverages", CoverageViewEditor.class);
        tester.assertComponent("form:coverages:bandChoiceContainer:coveragesChoice", ListMultipleChoice.class);
        tester.assertComponent("form:coverages:bandChoiceContainer:outputBandsChoice", ListMultipleChoice.class);
        tester.assertComponent("form:coverages:bandChoiceContainer:addBand", Button.class);
        CoverageViewEditor coverageViewEditor = (CoverageViewEditor)tester.getComponentFromLastRenderedPage("form:coverages");
        coverageViewEditor.setModelObject(null);
        ListMultipleChoice availableBands = (ListMultipleChoice)tester.getComponentFromLastRenderedPage("form:coverages:bandChoiceContainer:coveragesChoice");
        ListMultipleChoice selectedBands = (ListMultipleChoice)tester.getComponentFromLastRenderedPage("form:coverages:bandChoiceContainer:outputBandsChoice");
        FormTester formTester = tester.newFormTester("form");
        formTester.selectMultiple("coverages:bandChoiceContainer:coveragesChoice", new int[]{0});
        tester.executeAjaxEvent("form:coverages:bandChoiceContainer:addBand", "click");
        MatcherAssert.assertThat((Object)availableBands.getChoices().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(availableBands.getChoices().get(0), (Matcher)Is.is((Object)"time_domainsRanges"));
        MatcherAssert.assertThat((Object)selectedBands.getChoices().size(), (Matcher)Is.is((Object)1));
        CoverageView.CoverageBand selectedBand = (CoverageView.CoverageBand)selectedBands.getChoices().get(0);
        MatcherAssert.assertThat((Object)selectedBand.getDefinition(), (Matcher)Is.is((Object)"time_domainsRanges"));
        formTester.setValue("name", "bands_index_coverage_test");
        formTester.submit("save");
    }

    @Test
    public void testMultiBandsIndexIsVisible() throws Exception {
        this.login();
        CoverageViewNewPage newPage = new CoverageViewNewPage(MockData.TASMANIA_BM.getPrefix(), MockData.TASMANIA_BM.getLocalPart(), null, null);
        tester.startPage((Page)newPage);
        tester.assertComponent("form:coverages:bandChoiceContainer:outputBandsChoice", ListMultipleChoice.class);
        CoverageViewEditor coverageViewEditor = (CoverageViewEditor)tester.getComponentFromLastRenderedPage("form:coverages");
        coverageViewEditor.setModelObject(null);
        ListMultipleChoice availableBands = (ListMultipleChoice)tester.getComponentFromLastRenderedPage("form:coverages:bandChoiceContainer:coveragesChoice");
        ListMultipleChoice selectedBands = (ListMultipleChoice)tester.getComponentFromLastRenderedPage("form:coverages:bandChoiceContainer:outputBandsChoice");
        FormTester formTester = tester.newFormTester("form");
        formTester.selectMultiple("coverages:bandChoiceContainer:coveragesChoice", new int[]{0});
        tester.executeAjaxEvent("form:coverages:bandChoiceContainer:addBand", "click");
        MatcherAssert.assertThat((Object)availableBands.getChoices().size(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat(availableBands.getChoices().get(0), (Matcher)Is.is((Object)"tazbm@0"));
        MatcherAssert.assertThat((Object)selectedBands.getChoices().size(), (Matcher)Is.is((Object)1));
        CoverageView.CoverageBand selectedBand = (CoverageView.CoverageBand)selectedBands.getChoices().get(0);
        MatcherAssert.assertThat((Object)selectedBand.getDefinition(), (Matcher)Is.is((Object)"tazbm@0"));
        formTester.setValue("name", "bands_index_coverage_test");
        formTester.submit("save");
    }

    @Test
    public void testJiffleModeCreatesCorrectBands() throws Exception {
        this.login();
        CoverageViewNewPage newPage = new CoverageViewNewPage(MockData.TASMANIA_BM.getPrefix(), MockData.TASMANIA_BM.getLocalPart(), null, null);
        tester.startPage((Page)newPage);
        FormTester formTester = tester.newFormTester("form");
        formTester.select("coverages:compositionMode", 1);
        tester.executeAjaxEvent("form:coverages:compositionMode", "change");
        String jiffleScript = "res[0] = tazbm[0];\nres[1] = tazbm[1];\nres[2] = (tazbm[2] + 10);";
        TextField jiffleOutput = (TextField)tester.getComponentFromLastRenderedPage("form:coverages:jiffleEditorContainer:jiffleOutputName");
        jiffleOutput.setModelObject((Object)"res");
        TextArea jiffleFormulaField = (TextArea)tester.getComponentFromLastRenderedPage("form:coverages:jiffleEditorContainer:jiffleFormula");
        jiffleFormulaField.setModelObject((Object)jiffleScript);
        DropDownChoice referenceInput = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:coverages:jiffleEditorContainer:referenceInput");
        referenceInput.setModelObject((Object)"tazbm");
        formTester.setValue("name", "jiffle_based_view");
        CoverageViewEditor coverageViewEditor = (CoverageViewEditor)tester.getComponentFromLastRenderedPage("form:coverages");
        coverageViewEditor.validateAndSave();
        formTester.submit("save");
        List availableCoverages = coverageViewEditor.availableCoverages;
        MatcherAssert.assertThat((Object)((String)availableCoverages.get(0)), (Matcher)Is.is((Object)"tazbm@0"));
        MatcherAssert.assertThat((Object)((String)availableCoverages.get(1)), (Matcher)Is.is((Object)"tazbm@1"));
        MatcherAssert.assertThat((Object)((String)availableCoverages.get(2)), (Matcher)Is.is((Object)"tazbm@2"));
        List bands = coverageViewEditor.outputBandsChoice.getChoices();
        MatcherAssert.assertThat((Object)((CoverageView.CoverageBand)bands.get(0)).getDefinition(), (Matcher)Is.is((Object)"res@0"));
        MatcherAssert.assertThat((Object)((CoverageView.CoverageBand)bands.get(1)).getDefinition(), (Matcher)Is.is((Object)"res@1"));
        MatcherAssert.assertThat((Object)((CoverageView.CoverageBand)bands.get(2)).getDefinition(), (Matcher)Is.is((Object)"res@2"));
    }

    @Test
    public void testReferenceInput() throws Exception {
        this.login();
        CoverageViewNewPage newPage = new CoverageViewNewPage(S2MASK.getPrefix(), S2MASK.getLocalPart(), null, null);
        tester.startPage((Page)newPage);
        FormTester formTester = tester.newFormTester("form");
        formTester.select("coverages:compositionMode", 1);
        tester.executeAjaxEvent("form:coverages:compositionMode", "change");
        String jiffleScript = "if (MASK16 == 0) {NDVI = null;} else {NDVI = (B08 - B04) / (B04 + B08);}";
        TextField jiffleOutput = (TextField)tester.getComponentFromLastRenderedPage("form:coverages:jiffleEditorContainer:jiffleOutputName");
        jiffleOutput.setModelObject((Object)"NDVI");
        TextArea jiffleFormulaField = (TextArea)tester.getComponentFromLastRenderedPage("form:coverages:jiffleEditorContainer:jiffleFormula");
        jiffleFormulaField.setModelObject((Object)jiffleScript);
        formTester.setValue("name", "ndvitest");
        DropDownChoice referenceInput = (DropDownChoice)tester.getComponentFromLastRenderedPage("form:coverages:jiffleEditorContainer:referenceInput");
        referenceInput.setModelObject((Object)"B08");
        CoverageViewEditor coverageViewEditor = (CoverageViewEditor)tester.getComponentFromLastRenderedPage("form:coverages");
        coverageViewEditor.validateAndSave();
        formTester.submit("save");
        List outputBands = coverageViewEditor.currentOutputBands;
        MatcherAssert.assertThat((Object)((CoverageView.InputCoverageBand)((CoverageView.CoverageBand)outputBands.get(0)).getInputCoverageBands().get(0)).getCoverageName(), (Matcher)Is.is((Object)"B08"));
    }
}

