/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnEventHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerPagingNavigator;
import org.geoserver.web.wicket.ParamResourceModel;

public abstract class GeoServerTablePanel<T>
extends Panel {
    private static final long serialVersionUID = -5275268446479549108L;
    private static final int DEFAULT_ITEMS_PER_PAGE = 25;
    public static final String FILTER_PARAM = "filter";
    public static final String FILTER_INPUTS = "userInput";
    public static final String SORT_INPUTS = "userSort";
    TextField<String> filter;
    DataView<T> dataView;
    WebMarkupContainer listContainer;
    PagerDelegate pagerDelegate;
    Pager navigatorTop;
    Pager navigatorBottom;
    GeoServerDataProvider<T> dataProvider;
    Form<?> filterForm;
    CheckBox selectAll;
    AjaxButton hiddenSubmit;
    AjaxLink clearFilter;
    boolean sortable = true;
    boolean selectable = true;
    boolean[] selection;
    boolean selectAllValue;
    boolean pageable;

    public GeoServerTablePanel(String id, GeoServerDataProvider<T> dataProvider) {
        this(id, dataProvider, false);
    }

    public GeoServerTablePanel(String id, final GeoServerDataProvider<T> dataProvider, final boolean selectable) {
        super(id);
        SortParam<Object> previousSort;
        this.dataProvider = dataProvider;
        Boolean keepFilter = this.getRequest().getRequestParameters().getParameterValue(FILTER_PARAM).toBoolean(true);
        String previousInput = this.loadPreviousInput();
        if (previousInput != null && keepFilter.booleanValue()) {
            if (!previousInput.isEmpty()) {
                dataProvider.setKeywords(this.loadPreviousInput().split("\\s+"));
            }
        } else if (!keepFilter.booleanValue()) {
            this.clearFilterFromSession();
            previousInput = null;
        }
        if ((previousSort = this.loadPreviousSort()) != null && keepFilter.booleanValue()) {
            dataProvider.setSort(previousSort);
        } else if (!keepFilter.booleanValue()) {
            this.clearSortFromSession();
            previousInput = null;
        }
        this.selection = new boolean[25];
        this.listContainer = new WebMarkupContainer("listContainer");
        this.filterForm = new Form("filterForm");
        this.filterForm.setOutputMarkupId(true);
        this.add(new Component[]{this.filterForm});
        this.filter = new TextField<String>(FILTER_PARAM, (IModel)new Model()){
            private static final long serialVersionUID = -1252520208030081584L;

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                response.render((HeaderItem)OnEventHeaderItem.forComponent((Component)this, (String)"keypress", (CharSequence)("if(event.keyCode == 13) {document.getElementById('" + GeoServerTablePanel.this.hiddenSubmit.getMarkupId() + "').click();return false;}")));
            }

            protected void onBeforeRender() {
                super.onBeforeRender();
                String previousInput = GeoServerTablePanel.this.loadPreviousInput();
                if (previousInput != null && !previousInput.isEmpty()) {
                    this.setModelObject(previousInput);
                }
            }
        };
        this.filterForm.add(new Component[]{this.filter});
        this.filter.add(new Behavior[]{AttributeModifier.replace((String)"title", (Serializable)((Object)String.valueOf(new ResourceModel("GeoServerTablePanel.search", "Search").getObject())))});
        Component[] componentArray = new Component[1];
        this.hiddenSubmit = this.hiddenSubmit();
        componentArray[0] = this.hiddenSubmit;
        this.filterForm.add(componentArray);
        this.filterForm.setDefaultButton((IFormSubmittingComponent)this.hiddenSubmit);
        this.clearFilter = this.getClearFilterLink(previousInput);
        this.filterForm.add(new Component[]{this.clearFilter});
        this.listContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.listContainer});
        this.dataView = new DataView<T>("items", (IDataProvider)dataProvider){
            private static final long serialVersionUID = 7201317388415148823L;

            protected Item<T> newItem(String id, int index, IModel<T> model) {
                OddEvenItem item = new OddEvenItem(id, index, model);
                item.setOutputMarkupId(true);
                return item;
            }

            protected void populateItem(Item<T> item) {
                IModel itemModel = item.getModel();
                WebMarkupContainer cnt = new WebMarkupContainer("selectItemContainer");
                cnt.add(new Component[]{GeoServerTablePanel.this.selectOneCheckbox(item)});
                cnt.setVisible(selectable);
                item.add(new Component[]{cnt});
                GeoServerTablePanel.this.buildRowListView(dataProvider, item, itemModel);
            }
        };
        this.dataView.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        this.listContainer.add(new Component[]{this.dataView});
        WebMarkupContainer cnt = new WebMarkupContainer("selectAllContainer");
        Component[] componentArray2 = new Component[1];
        this.selectAll = this.selectAllCheckbox();
        componentArray2[0] = this.selectAll;
        cnt.add(componentArray2);
        cnt.setVisible(selectable);
        this.listContainer.add(new Component[]{cnt});
        this.listContainer.add(new Component[]{this.buildLinksListView(dataProvider)});
        this.dataView.setItemsPerPage(25L);
        this.pagerDelegate = new PagerDelegate();
        Component[] componentArray3 = new Component[1];
        this.navigatorTop = new Pager("navigatorTop");
        componentArray3[0] = this.navigatorTop;
        this.filterForm.add(componentArray3);
        this.navigatorTop.setOutputMarkupId(true);
        Component[] componentArray4 = new Component[1];
        this.navigatorBottom = new Pager("navigatorBottom");
        componentArray4[0] = this.navigatorBottom;
        this.add(componentArray4);
        this.navigatorBottom.setOutputMarkupId(true);
    }

    protected ListView<GeoServerDataProvider.Property<T>> buildLinksListView(final GeoServerDataProvider<T> dataProvider) {
        return new ListView<GeoServerDataProvider.Property<T>>("sortableLinks", dataProvider.getVisibleProperties()){
            private static final long serialVersionUID = -7565457802398721254L;

            protected void populateItem(ListItem<GeoServerDataProvider.Property<T>> item) {
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)item.getModelObject();
                IModel<String> titleModel = GeoServerTablePanel.this.getPropertyTitle(property);
                if (GeoServerTablePanel.this.sortable && property.getComparator() != null) {
                    Fragment f = new Fragment("header", "sortableHeader", (MarkupContainer)GeoServerTablePanel.this);
                    AjaxLink link = GeoServerTablePanel.this.sortLink(dataProvider, item);
                    link.add(new Component[]{new Label("label", titleModel)});
                    f.add(new Component[]{link});
                    item.add(new Component[]{f});
                } else {
                    item.add(new Component[]{new Label("header", titleModel)});
                }
            }
        };
    }

    protected void buildRowListView(final GeoServerDataProvider<T> dataProvider, Item<T> item, final IModel<T> itemModel) {
        LoadableDetachableModel propertyList = new LoadableDetachableModel<List<GeoServerDataProvider.Property<T>>>(){

            protected List<GeoServerDataProvider.Property<T>> load() {
                return dataProvider.getVisibleProperties();
            }
        };
        ListView items = new ListView<GeoServerDataProvider.Property<T>>("itemProperties", (IModel)propertyList){
            private static final long serialVersionUID = -4552413955986008990L;

            protected void populateItem(ListItem<GeoServerDataProvider.Property<T>> item) {
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)item.getModelObject();
                Component component = GeoServerTablePanel.this.getComponentForProperty("component", itemModel, property);
                if (component == null) {
                    component = new Label("component", property.getModel(itemModel));
                } else if (!"component".equals(component.getId())) {
                    throw new IllegalArgumentException("getComponentForProperty asked to build a component with id = 'component' for property '" + property.getName() + "', but got '" + component.getId() + "' instead");
                }
                item.add(new Component[]{component});
                GeoServerTablePanel.this.onPopulateItem(property, item);
            }
        };
        items.setReuseItems(true);
        item.add(new Component[]{items});
    }

    public void setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.dataView.setItemReuseStrategy(strategy);
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public Component getTopPager() {
        return this.navigatorTop;
    }

    public Component getBottomPager() {
        return this.navigatorBottom;
    }

    public GeoServerDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    protected void onSelectionUpdate(AjaxRequestTarget target) {
    }

    protected IModel<String> getPropertyTitle(GeoServerDataProvider.Property<T> property) {
        ResourceModel resMod = new ResourceModel("th." + property.getName(), property.getName());
        return resMod;
    }

    public int getNumSelected() {
        int selected = 0;
        for (boolean itemSelected : this.selection) {
            if (!itemSelected) continue;
            ++selected;
        }
        return selected;
    }

    public List<T> getSelection() {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        for (Component item : this.dataView) {
            if (this.selection[i]) {
                result.add(item.getDefaultModelObject());
            }
            ++i;
        }
        return result;
    }

    CheckBox selectAllCheckbox() {
        CheckBox sa = new CheckBox("selectAll", (IModel)new PropertyModel((Object)this, "selectAllValue"));
        sa.setOutputMarkupId(true);
        sa.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){
            private static final long serialVersionUID = 1154921156065269691L;

            protected void onUpdate(AjaxRequestTarget target) {
                GeoServerTablePanel.this.setSelection(GeoServerTablePanel.this.selectAllValue);
                target.add(new Component[]{this.getComponent()});
                target.add(new Component[]{GeoServerTablePanel.this.listContainer});
                GeoServerTablePanel.this.onSelectionUpdate(target);
            }
        }});
        return sa;
    }

    protected CheckBox selectOneCheckbox(Item<T> item) {
        CheckBox cb = new CheckBox("selectItem", (IModel)new SelectionModel(item.getIndex()));
        cb.setOutputMarkupId(true);
        cb.setVisible(this.selectable);
        cb.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("click"){
            private static final long serialVersionUID = -2419184741329470638L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (Boolean.FALSE.equals(this.getComponent().getDefaultModelObject())) {
                    GeoServerTablePanel.this.selectAllValue = false;
                    target.add(new Component[]{GeoServerTablePanel.this.selectAll});
                }
                GeoServerTablePanel.this.onSelectionUpdate(target);
            }
        }});
        return cb;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
        this.selectAll.setVisible(selectable);
    }

    void setSelection(boolean selected) {
        for (int i = 0; i < this.selection.length; ++i) {
            this.selection[i] = selected;
        }
        this.selectAllValue = selected;
    }

    public void clearSelection() {
        this.setSelection(false);
    }

    public void selectAll() {
        this.setSelection(true);
    }

    public void selectObject(T object) {
        int i = 0;
        for (Component component : this.dataView) {
            Item item = (Item)component;
            if (object.equals(item.getModelObject())) {
                this.selection[i] = true;
                return;
            }
            ++i;
        }
    }

    public void selectIndex(int i) {
        this.validateSelectionIndex(i);
        this.selection[i] = true;
    }

    public void unseelectIndex(int i) {
        this.validateSelectionIndex(i);
        this.selection[i] = false;
    }

    public void validateSelectionIndex(int i) {
        if (this.selection.length <= i) {
            if (this.dataProvider.size() <= (long)i) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            boolean[] newSelection = new boolean[(int)this.dataProvider.size()];
            System.arraycopy(this.selection, 0, newSelection, 0, this.selection.length);
            this.selection = newSelection;
        }
    }

    AjaxButton hiddenSubmit() {
        return new AjaxButton("submit"){
            static final long serialVersionUID = 5334592790005438960L;

            protected void onSubmit(AjaxRequestTarget target) {
                GeoServerTablePanel.this.updateFilter(target, GeoServerTablePanel.this.filter.getDefaultModelObjectAsString());
                GeoServerTablePanel.this.rememeberFilter();
            }
        };
    }

    AjaxLink getClearFilterLink(String previousInput) {
        AjaxLink<Object> clearButton = new AjaxLink<Object>("clear"){
            static final long serialVersionUID = 5334592790005438960L;

            public void onClick(AjaxRequestTarget target) {
                GeoServerTablePanel.this.updateFilter(target, "");
                GeoServerTablePanel.this.filter.setModelObject((Object)"");
                GeoServerTablePanel.this.rememeberFilter();
                GeoServerTablePanel.this.clearFilter.setVisible(false);
                target.add(new Component[]{GeoServerTablePanel.this.filterForm});
            }
        };
        boolean visible = false;
        if (previousInput != null) {
            visible = !previousInput.isEmpty();
        }
        clearButton.setVisible(visible);
        return clearButton;
    }

    public void setItemsPerPage(int items) {
        this.dataView.setItemsPerPage((long)items);
        this.selection = new boolean[items];
    }

    public GeoServerTablePanel<T> setFilterable(boolean filterable) {
        this.filterForm.setVisible(filterable);
        return this;
    }

    <S> AjaxLink<S> sortLink(final GeoServerDataProvider<T> dataProvider, ListItem<S> item) {
        return new AjaxLink<S>("link", item.getModel()){
            private static final long serialVersionUID = -6180419488076488737L;

            public void onClick(AjaxRequestTarget target) {
                SortParam currSort = dataProvider.getSort();
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)this.getModelObject();
                if (currSort == null || !property.getName().equals(currSort.getProperty())) {
                    dataProvider.setSort(new SortParam((Object)property.getName(), true));
                } else {
                    dataProvider.setSort(new SortParam((Object)property.getName(), !currSort.isAscending()));
                }
                GeoServerTablePanel.this.setSelection(false);
                target.add(new Component[]{GeoServerTablePanel.this.listContainer});
                GeoServerTablePanel.this.rememeberSort();
            }
        };
    }

    private void updateFilter(AjaxRequestTarget target, String flatKeywords) {
        if ("".equals(flatKeywords)) {
            this.dataProvider.setKeywords(null);
            this.filter.setModelObject((Object)"");
            this.dataView.setCurrentPage(0L);
        } else {
            String[] keywords = flatKeywords.split("\\s+");
            this.dataProvider.setKeywords(keywords);
            this.dataView.setCurrentPage(0L);
        }
        this.pagerDelegate.updateMatched();
        this.navigatorTop.updateMatched();
        this.navigatorBottom.updateMatched();
        this.setSelection(false);
        this.clearFilter.setVisible(true);
        target.add(new Component[]{this.listContainer});
        target.add(new Component[]{this.navigatorTop});
        target.add(new Component[]{this.navigatorBottom});
        target.add(new Component[]{this.filterForm});
    }

    public void reset() {
        this.dataView.setCurrentPage(0L);
        this.clearSelection();
        this.dataProvider.setSort(null);
    }

    public void setFilterVisible(boolean filterVisible) {
        this.filterForm.setVisible(filterVisible);
    }

    public void processInputs() {
        this.visitChildren(FormComponent.class, (component, visit) -> {
            ((FormComponent)component).processInput();
            visit.dontGoDeeper();
        });
    }

    protected abstract Component getComponentForProperty(String var1, IModel<T> var2, GeoServerDataProvider.Property<T> var3);

    protected void onPopulateItem(GeoServerDataProvider.Property<T> property, ListItem<GeoServerDataProvider.Property<T>> item) {
    }

    IModel<String> showingAllRecords(long first, long last, long size) {
        return new ParamResourceModel("showingAllRecords", (Component)this, first, last, size);
    }

    IModel<String> matchedXOutOfY(long first, long last, long size, long fullSize) {
        return new ParamResourceModel("matchedXOutOfY", (Component)this, first, last, size, fullSize);
    }

    public void setPageable(boolean pageable) {
        if (!pageable) {
            this.navigatorTop.setVisible(false);
            this.navigatorBottom.setVisible(false);
            this.dataView.setItemsPerPage(Integer.MAX_VALUE);
            this.selection = new boolean[this.getDataProvider().getItems().size()];
        } else {
            this.navigatorTop.setVisible(true);
            this.navigatorBottom.setVisible(true);
            this.dataView.setItemsPerPage(25L);
            this.selection = new boolean[25];
        }
    }

    private void rememeberFilter() {
        MetadataMap filters = this.getMetaDataMapFromSession(FILTER_INPUTS);
        if (this.filter.getDefaultModelObjectAsString().isEmpty() && filters != null) {
            filters.put(((Object)this.dataProvider).getClass().getName(), null);
            return;
        }
        if (filters == null) {
            filters = new MetadataMap();
            this.getSession().setAttribute(FILTER_INPUTS, (Serializable)filters);
        }
        filters.put(((Object)this.dataProvider).getClass().getName(), (Serializable)((Object)this.filter.getDefaultModelObjectAsString()));
    }

    private void rememeberSort() {
        MetadataMap sorts = this.getMetaDataMapFromSession(SORT_INPUTS);
        if (sorts == null) {
            sorts = new MetadataMap();
            this.getSession().setAttribute(SORT_INPUTS, (Serializable)sorts);
        }
        sorts.put(((Object)this.dataProvider).getClass().getName(), (Serializable)this.dataProvider.getSort());
    }

    private String loadPreviousInput() {
        MetadataMap filters = this.getMetaDataMapFromSession(FILTER_INPUTS);
        if (filters == null) {
            return null;
        }
        if (filters.get(((Object)this.dataProvider).getClass().getName(), String.class) == null) {
            return null;
        }
        return (String)filters.get(((Object)this.dataProvider).getClass().getName(), String.class);
    }

    private SortParam<Object> loadPreviousSort() {
        MetadataMap filters = this.getMetaDataMapFromSession(SORT_INPUTS);
        if (filters == null) {
            return null;
        }
        if (filters.get(((Object)this.dataProvider).getClass().getName(), SortParam.class) == null) {
            return null;
        }
        SortParam result = (SortParam)filters.get(((Object)this.dataProvider).getClass().getName(), SortParam.class);
        return result;
    }

    private void clearFilterFromSession() {
        MetadataMap filters = this.getMetaDataMapFromSession(FILTER_INPUTS);
        if (filters != null) {
            filters.put(((Object)this.dataProvider).getClass().getName(), null);
        }
        this.dataProvider.setKeywords(null);
    }

    private void clearSortFromSession() {
        MetadataMap sorts = this.getMetaDataMapFromSession(SORT_INPUTS);
        if (sorts != null) {
            sorts.put(((Object)this.dataProvider).getClass().getName(), null);
        }
        this.dataProvider.setKeywords(null);
    }

    private MetadataMap getMetaDataMapFromSession(String key) {
        return (MetadataMap)this.getSession().getAttribute(key);
    }

    public class SelectionModel
    implements IModel<Boolean> {
        private static final long serialVersionUID = 7681891298556441330L;
        int index;

        public SelectionModel(int index) {
            this.index = index;
            GeoServerTablePanel.this.validateSelectionIndex(index);
        }

        public Boolean getObject() {
            return GeoServerTablePanel.this.selection[this.index];
        }

        public void setObject(Boolean object) {
            GeoServerTablePanel.this.selection[this.index] = object;
        }
    }

    protected class Pager
    extends Panel {
        private static final long serialVersionUID = 6128188748404971154L;
        GeoServerPagingNavigator navigator;
        Label matched;

        Pager(String id) {
            super(id);
            Component[] componentArray = new Component[1];
            this.navigator = this.updatingPagingNavigator();
            componentArray[0] = this.navigator;
            this.add(componentArray);
            Component[] componentArray2 = new Component[1];
            this.matched = new Label("filterMatch", (IModel)new Model());
            componentArray2[0] = this.matched;
            this.add(componentArray2);
            this.updateMatched();
        }

        private GeoServerPagingNavigator updatingPagingNavigator() {
            return new GeoServerPagingNavigator("navigator", (IPageable)GeoServerTablePanel.this.dataView){
                private static final long serialVersionUID = -1795278469204272385L;

                protected void onAjaxEvent(AjaxRequestTarget target) {
                    super.onAjaxEvent(target);
                    GeoServerTablePanel.this.setSelection(false);
                    GeoServerTablePanel.this.pagerDelegate.updateMatched();
                    GeoServerTablePanel.this.navigatorTop.updateMatched();
                    GeoServerTablePanel.this.navigatorBottom.updateMatched();
                    target.add(new Component[]{GeoServerTablePanel.this.navigatorTop});
                    target.add(new Component[]{GeoServerTablePanel.this.navigatorBottom});
                }
            };
        }

        void updateMatched() {
            this.matched.setDefaultModel(GeoServerTablePanel.this.pagerDelegate.model());
        }
    }

    protected class PagerDelegate
    implements Serializable {
        private static final long serialVersionUID = -6928477338531850338L;
        long fullSize;
        long size;
        long first;
        long last;

        public PagerDelegate() {
            this.updateMatched();
        }

        void updateMatched() {
            this.size = GeoServerTablePanel.this.dataProvider.size();
            this.fullSize = GeoServerTablePanel.this.dataProvider.fullSize();
            this.first = this.first(this.size);
            this.last = this.last(this.size);
        }

        public IModel<String> model() {
            if (GeoServerTablePanel.this.dataProvider.getKeywords() == null) {
                return GeoServerTablePanel.this.showingAllRecords(this.first, this.last, this.fullSize);
            }
            return GeoServerTablePanel.this.matchedXOutOfY(this.first, this.last, this.size, this.fullSize);
        }

        long first(long size) {
            if (GeoServerTablePanel.this.dataProvider.getKeywords() != null) {
                size = GeoServerTablePanel.this.dataView.getDataProvider().size();
            }
            if (size > 0L) {
                return GeoServerTablePanel.this.dataView.getItemsPerPage() * GeoServerTablePanel.this.dataView.getCurrentPage() + 1L;
            }
            return 0L;
        }

        long last(long size) {
            long count = this.optGetPageCount(size);
            long page = GeoServerTablePanel.this.dataView.getCurrentPage();
            if (page < count - 1L) {
                return GeoServerTablePanel.this.dataView.getItemsPerPage() * (page + 1L);
            }
            return GeoServerTablePanel.this.dataProvider.getKeywords() != null ? GeoServerTablePanel.this.dataView.getDataProvider().size() : size;
        }

        long optGetPageCount(long total) {
            long count;
            long page = GeoServerTablePanel.this.dataView.getItemsPerPage();
            if (page * (count = total / page) < total) {
                ++count;
            }
            return count;
        }
    }
}

