/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.apache.wicket.validation.validator.UrlValidator;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;

public class FileExistsValidator
implements IValidator<String> {
    private UrlValidator delegate;
    File baseDirectory = null;

    public FileExistsValidator() {
        this(true);
    }

    public FileExistsValidator(boolean allowRemoteUrl) {
        if (allowRemoteUrl) {
            this.delegate = new UrlValidator();
        }
    }

    public void validate(IValidatable<String> validatable) {
        String uriSpec = (String)validatable.getValue();
        try {
            URI uri = new URI(uriSpec);
            if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
                if (this.delegate != null) {
                    this.delegate.validate(validatable);
                    try {
                        URLConnection connection = uri.toURL().openConnection();
                        connection.setConnectTimeout(10000);
                        InputStream ignored = connection.getInputStream();
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                    catch (Exception e) {
                        ValidationError err = new ValidationError("FileExistsValidator.unreachable").addKey("FileExistsValidator.unreachable").setVariable("file", (Object)uriSpec);
                        validatable.error((IValidationError)err);
                    }
                }
                return;
            }
            String path = uri.getPath();
            if (path != null && new File(path).exists()) {
                return;
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        File relFile = null;
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        relFile = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)(this.baseDirectory == null ? loader.getBaseDirectory() : this.baseDirectory)), (String)uriSpec), (boolean)true);
        if (relFile == null || !relFile.exists()) {
            ValidationError err = new ValidationError("FileExistsValidator.fileNotFoundError").addKey("FileExistsValidator.fileNotFoundError").setVariable("file", (Object)uriSpec);
            validatable.error((IValidationError)err);
        }
    }
}

