/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.web.publish.PublishedEditTabPanel;
import org.geoserver.web.security.AccessDataRuleInfoManager;
import org.geoserver.web.security.AccessDataRulePanel;
import org.geoserver.web.security.DataAccessRuleInfo;

public class LayerAccessDataRulePanel
extends PublishedEditTabPanel<PublishedInfo> {
    private AccessDataRulePanel dataAccessPanel;
    private IModel<List<DataAccessRuleInfo>> ownModel;
    private IModel<? extends PublishedInfo> model;

    public LayerAccessDataRulePanel(String id, IModel<? extends PublishedInfo> model, IModel<List<DataAccessRuleInfo>> ownModel) {
        super(id, model);
        this.model = model;
        this.ownModel = ownModel;
        Component[] componentArray = new Component[1];
        this.dataAccessPanel = new AccessDataRulePanel("dataAccessPanel", model, ownModel);
        componentArray[0] = this.dataAccessPanel;
        this.add(componentArray);
    }

    @Override
    public void save() throws IOException {
        this.dataAccessPanel.save();
    }

    public IModel<List<DataAccessRuleInfo>> getOwnModel() {
        return this.ownModel;
    }

    public void setOwnModel(IModel<List<DataAccessRuleInfo>> ownModel) {
        this.ownModel = ownModel;
    }

    public void reloadOwnModel() {
        LayerGroupInfo group = (LayerGroupInfo)this.model.getObject();
        AccessDataRuleInfoManager infoManager = new AccessDataRuleInfoManager();
        String wsName = group.getWorkspace() != null ? group.getWorkspace().getName() : null;
        Set<DataAccessRule> rules = infoManager.getResourceRule(wsName, (CatalogInfo)group);
        this.ownModel.setObject(infoManager.mapTo(rules, infoManager.getAvailableRoles(), wsName, group.getName()));
    }
}

