/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.publish;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.extensions.markup.html.tabs.TabbedPanel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.data.resource.LayerModel;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.publish.PublishedConfigurationPanelInfo;
import org.geoserver.web.publish.PublishedEditTabPanel;
import org.geoserver.web.publish.PublishedEditTabPanelInfo;
import org.geoserver.web.security.LayerAccessDataRulePanel;

public abstract class PublishedConfigurationPage<T extends PublishedInfo>
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 7870938096047218989L;
    public static final String NAME = "name";
    public static final String WORKSPACE = "wsName";
    protected IModel<T> myModel;
    protected boolean isNew;
    protected TabbedPanel<ITab> tabbedPanel;
    private LinkedHashMap<Class<? extends PublishedEditTabPanel<T>>, IModel<?>> tabPanelCustomModels;
    private boolean inputEnabled = true;

    protected PublishedConfigurationPage(boolean isNew) {
        this.isNew = isNew;
    }

    protected PublishedConfigurationPage(T info, boolean isNew) {
        this.isNew = isNew;
        this.setupPublished(info);
    }

    protected void setupPublished(T info) {
        this.setupPublished(info instanceof LayerInfo ? new LayerModel((LayerInfo)info) : new Model(info));
    }

    protected void setupPublished(IModel<T> infoModel) {
        this.myModel = new CompoundPropertyModel(infoModel);
        this.initComponents();
    }

    private void initComponents() {
        this.tabPanelCustomModels = new LinkedHashMap();
        this.add(new Component[]{new Label("publishedinfoname", (Serializable)((Object)this.getPublishedInfo().prefixedName()))});
        Form theForm = new Form("publishedinfo", this.myModel);
        this.add(new Component[]{theForm});
        theForm.add(new IFormValidator(){

            public FormComponent<?>[] getDependentFormComponents() {
                return new FormComponent[0];
            }

            public void validate(Form<?> form) {
            }
        });
        final ArrayList<AbstractTab> tabs = new ArrayList<AbstractTab>();
        tabs.add(new AbstractTab((IModel)new ResourceModel("ResourceConfigurationPage.Data")){
            private static final long serialVersionUID = 1L;

            public Panel getPanel(String panelID) {
                return PublishedConfigurationPage.this.createMainTab(panelID).setInputEnabled(PublishedConfigurationPage.this.inputEnabled);
            }
        });
        tabs.add(new AbstractTab((IModel)new ResourceModel("ResourceConfigurationPage.Publishing")){
            private static final long serialVersionUID = 1L;

            public Panel getPanel(String panelID) {
                return new PublishingEditTabPanel(panelID).setInputEnabled(PublishedConfigurationPage.this.inputEnabled);
            }
        });
        List<PublishedEditTabPanelInfo> tabPanels = this.tabPanelsExtensions();
        this.sortTabPanels(tabPanels);
        for (PublishedEditTabPanelInfo ttabPanelInfo : tabPanels) {
            if (!ttabPanelInfo.supports((PublishedInfo)this.getPublishedInfo())) continue;
            PublishedEditTabPanelInfo tabPanelInfo = ttabPanelInfo;
            String titleKey = tabPanelInfo.getTitleKey();
            Object titleModel = null;
            titleModel = titleKey != null ? new ResourceModel(titleKey) : new Model((Serializable)((Object)tabPanelInfo.getComponentClass().getSimpleName()));
            final Class panelClass = tabPanelInfo.getComponentClass();
            IModel<?> panelCustomModel = tabPanelInfo.createOwnModel(this.myModel, this.isNew);
            this.tabPanelCustomModels.put(panelClass, panelCustomModel);
            tabs.add(new AbstractTab((IModel)titleModel){
                private static final long serialVersionUID = -6637277497986497791L;

                public Panel getPanel(String panelId) {
                    IModel<?> panelCustomModel = PublishedConfigurationPage.this.tabPanelCustomModels.get(panelClass);
                    PublishedEditTabPanel<?> tabPanel = PublishedConfigurationPage.this.createTabPanel(panelId, panelCustomModel, panelClass);
                    return tabPanel;
                }
            });
        }
        this.tabbedPanel = new TabbedPanel<ITab>("tabs", tabs){
            private static final long serialVersionUID = 1L;

            protected WebMarkupContainer newLink(String linkId, final int index) {
                return new SubmitLink(linkId){
                    private static final long serialVersionUID = 1L;

                    public void onSubmit() {
                        WebMarkupContainer panel = ((ITab)tabs.get(index)).getPanel("dataAccessPanel");
                        if (PublishedConfigurationPage.this.myModel.getObject() instanceof LayerGroupInfo && panel instanceof LayerAccessDataRulePanel) {
                            ((LayerAccessDataRulePanel)panel).reloadOwnModel();
                        }
                        this.setSelectedTab(index);
                    }
                };
            }
        };
        theForm.add(new Component[]{this.tabbedPanel});
        theForm.add(new Component[]{this.saveLink()});
        theForm.add(new Component[]{this.applyLink()});
        theForm.add(new Component[]{this.cancelLink()});
    }

    private PublishedEditTabPanel<?> createTabPanel(String panelId, IModel<?> panelCustomModel, Class<PublishedEditTabPanel<T>> panelClass) {
        PublishedEditTabPanel<T> tabPanel;
        try {
            tabPanel = panelCustomModel == null ? panelClass.getConstructor(String.class, IModel.class).newInstance(panelId, this.myModel) : panelClass.getConstructor(String.class, IModel.class, IModel.class).newInstance(panelId, this.myModel, panelCustomModel);
        }
        catch (Exception e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return tabPanel;
    }

    private void sortTabPanels(List<PublishedEditTabPanelInfo> tabPanels) {
        Collections.sort(tabPanels, (o1, o2) -> {
            Integer order1 = o1.getOrder() >= 0 ? o1.getOrder() : Integer.MAX_VALUE;
            Integer order2 = o2.getOrder() >= 0 ? o2.getOrder() : Integer.MAX_VALUE;
            return order1.compareTo(order2);
        });
    }

    private List<PublishedEditTabPanelInfo> tabPanelsExtensions() {
        return this.getGeoServerApplication().getBeansOfType(PublishedEditTabPanelInfo.class);
    }

    protected abstract PublishedEditTabPanel<T> createMainTab(String var1);

    protected abstract void doSaveInternal() throws IOException;

    public void setSelectedTab(Class<? extends PublishedEditTabPanel<?>> selectedTabClass) {
        int selectedTabIndex = new ArrayList<Class<PublishedEditTabPanel<T>>>(this.tabPanelCustomModels.keySet()).indexOf(selectedTabClass);
        if (selectedTabIndex > -1) {
            int diff = this.tabbedPanel.getTabs().size() - this.tabPanelCustomModels.size();
            this.tabbedPanel.setSelectedTab(selectedTabIndex + diff);
        }
    }

    public void selectDataTab() {
        this.tabbedPanel.setSelectedTab(0);
    }

    public void selectPublishingTab() {
        this.tabbedPanel.setSelectedTab(1);
    }

    protected void disableForm() {
        this.get("publishedinfo").setEnabled(false);
    }

    private SubmitLink saveLink() {
        return new SubmitLink("save"){
            private static final long serialVersionUID = 4615460713943555026L;

            public void onSubmit() {
                PublishedConfigurationPage.this.doSave(true);
            }
        };
    }

    private Component applyLink() {
        return new GeoserverAjaxSubmitLink("apply", (GeoServerBasePage)this){

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target) {
                PublishedConfigurationPage.this.doSave(false);
            }
        };
    }

    protected void doSave(boolean doReturn) {
        try {
            PublishedEditTabPanel<T> tabPanel;
            IModel<?> customModel;
            Class<PublishedEditTabPanel<T>> panelClass;
            for (Map.Entry<Class<PublishedEditTabPanel<T>>, IModel<?>> e : this.tabPanelCustomModels.entrySet()) {
                panelClass = e.getKey();
                customModel = e.getValue();
                if (customModel == null) continue;
                tabPanel = panelClass.getConstructor(String.class, IModel.class, IModel.class).newInstance("temp", this.myModel, customModel);
                tabPanel.beforeSave();
            }
            this.doSaveInternal();
            if (this.hasErrorMessage()) {
                return;
            }
            for (Map.Entry<Class<PublishedEditTabPanel<T>>, IModel<?>> e : this.tabPanelCustomModels.entrySet()) {
                panelClass = e.getKey();
                customModel = e.getValue();
                if (customModel == null) continue;
                tabPanel = panelClass.getConstructor(String.class, IModel.class, IModel.class).newInstance("temp", this.myModel, customModel);
                tabPanel.save();
            }
            this.onSuccessfulSave(doReturn);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error saving layer", e);
            this.error((Serializable)((Object)GeoServerApplication.getMessage((Component)this, e)));
        }
    }

    private Link<?> cancelLink() {
        return new Link<Object>("cancel"){
            private static final long serialVersionUID = -9007727127569731882L;

            public void onClick() {
                PublishedConfigurationPage.this.onCancel();
            }
        };
    }

    private List<PublishedConfigurationPanelInfo<T>> filterPublishedPanels(List<PublishedConfigurationPanelInfo> list) {
        ArrayList<PublishedConfigurationPanelInfo<T>> result = new ArrayList<PublishedConfigurationPanelInfo<T>>();
        for (PublishedConfigurationPanelInfo info : list) {
            if (!info.canHandle((PublishedInfo)this.getPublishedInfo())) continue;
            result.add(info);
        }
        return result;
    }

    public T getPublishedInfo() {
        return (T)((PublishedInfo)this.myModel.getObject());
    }

    protected void onSuccessfulSave(boolean doReturn) {
        if (doReturn) {
            this.doReturn();
        }
    }

    protected void onCancel() {
        this.doReturn();
    }

    public void updatePublishedInfo(T info) {
        this.myModel.setObject(info);
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }

    public void setInputEnabled(boolean inputEnabled) {
        this.inputEnabled = inputEnabled;
        this.get("publishedinfo:save").setVisible(inputEnabled);
    }

    protected class PublishingEditTabPanel
    extends ListEditTabPanel {
        private static final long serialVersionUID = -6575960326680386479L;

        public PublishingEditTabPanel(String id) {
            super(id);
        }

        public ListView<PublishedConfigurationPanelInfo<T>> createList(String id) {
            List pubPanels = PublishedConfigurationPage.this.filterPublishedPanels(PublishedConfigurationPage.this.getGeoServerApplication().getBeansOfType(PublishedConfigurationPanelInfo.class));
            ListView pubPanelList = new ListView<PublishedConfigurationPanelInfo<T>>(id, pubPanels){
                private static final long serialVersionUID = 1L;

                protected void populateItem(ListItem<PublishedConfigurationPanelInfo<T>> item) {
                    PublishedConfigurationPanelInfo panelInfo = (PublishedConfigurationPanelInfo)item.getModelObject();
                    try {
                        PublishedConfigurationPanel panel = (PublishedConfigurationPanel)((Object)panelInfo.getComponentClass().getConstructor(String.class, IModel.class).newInstance("content", PublishedConfigurationPage.this.myModel));
                        panel.setOutputMarkupId(true);
                        item.add(new Component[]{panel});
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException("Failed to add pluggable layer configuration panels", (Throwable)e);
                    }
                }
            };
            return pubPanelList;
        }
    }

    protected abstract class ListEditTabPanel
    extends PublishedEditTabPanel<T> {
        private static final long serialVersionUID = -7279044666531992361L;

        public ListEditTabPanel(String id) {
            super(id, PublishedConfigurationPage.this.myModel);
            ListView<?> list = this.createList("theList");
            list.setReuseItems(true);
            this.add(new Component[]{list});
        }

        protected abstract ListView<?> createList(String var1);
    }
}

