/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store.shape;

import java.io.FileFilter;
import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidator;
import org.geoserver.web.data.store.StoreEditPanel;
import org.geoserver.web.data.store.panel.CharsetPanel;
import org.geoserver.web.data.store.panel.CheckBoxParamPanel;
import org.geoserver.web.data.store.panel.FileParamPanel;
import org.geoserver.web.util.MapModel;
import org.geoserver.web.wicket.FileExistsValidator;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.browser.ExtensionFileFilter;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;

public class ShapefileStoreEditPanel
extends StoreEditPanel {
    public ShapefileStoreEditPanel(String componentId, Form storeEditForm) {
        super(componentId, storeEditForm);
        IModel model = storeEditForm.getModel();
        this.setDefaultModel(model);
        PropertyModel paramsModel = new PropertyModel((Object)model, "connectionParameters");
        Panel file = this.buildFileParamPanel((IModel<Map<String, Object>>)paramsModel);
        this.add(new Component[]{file});
        this.add(new Component[]{new CharsetPanel("charset", new MapModel<String>((IModel<? extends Map<String, ? extends Object>>)paramsModel, ShapefileDataStoreFactory.DBFCHARSET.key), (IModel<String>)new ParamResourceModel("charset", (Component)this, new Object[0]), false)});
        this.add(new Component[]{new CheckBoxParamPanel("memoryMapped", new MapModel<Boolean>((IModel<? extends Map<String, ? extends Object>>)paramsModel, ShapefileDataStoreFactory.MEMORY_MAPPED.key), (IModel)new ParamResourceModel("memoryMapped", (Component)this, new Object[0]))});
        this.add(new Component[]{new CheckBoxParamPanel("cacheMemoryMaps", new MapModel<Boolean>((IModel<? extends Map<String, ? extends Object>>)paramsModel, ShapefileDataStoreFactory.CACHE_MEMORY_MAPS.key), (IModel)new ParamResourceModel("cacheMemoryMaps", (Component)this, new Object[0]))});
        this.add(new Component[]{new CheckBoxParamPanel("spatialIndex", new MapModel<Boolean>((IModel<? extends Map<String, ? extends Object>>)paramsModel, ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key), (IModel)new ParamResourceModel("spatialIndex", (Component)this, new Object[0]))});
    }

    protected Panel buildFileParamPanel(IModel<Map<String, Object>> paramsModel) {
        FileParamPanel file = new FileParamPanel("url", new MapModel<String>(paramsModel, ShapefileDataStoreFactory.URLP.key), (IModel<String>)new ParamResourceModel("shapefile", (Component)this, new Object[0]), true, new IValidator[0]);
        file.setFileFilter((IModel<? extends FileFilter>)new Model((Serializable)new ExtensionFileFilter(".shp")));
        file.getFormComponent().add((IValidator)new FileExistsValidator());
        return file;
    }
}

