/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.resource.MetadataMapValidator;
import org.geoserver.web.data.resource.ResourceConfigurationPanel;
import org.geoserver.web.data.resource.ResourceConfigurationPanelInfo;
import org.geoserver.web.data.resource.ResourceModel;
import org.geoserver.web.publish.PublishedConfigurationPage;
import org.geoserver.web.publish.PublishedConfigurationPanel;
import org.geoserver.web.publish.PublishedEditTabPanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.Bounds;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.GeoTools;

public class ResourceConfigurationPage
extends PublishedConfigurationPage<LayerInfo> {
    private static final long serialVersionUID = 7870938096047218989L;
    IModel<ResourceInfo> myResourceModel;

    public ResourceConfigurationPage(PageParameters parameters) {
        this(parameters.get("wsName").toOptionalString(), parameters.get("name").toString());
    }

    public ResourceConfigurationPage(String workspaceName, String layerName) {
        super(false);
        LayerInfo layer;
        this.returnPageClass = LayerPage.class;
        if (workspaceName != null) {
            NamespaceInfo ns = this.getCatalog().getNamespaceByPrefix(workspaceName);
            if (ns == null) {
                throw new RuntimeException("Could not find workspace " + workspaceName);
            }
            layer = this.getCatalog().getLayerByName(ns.getName() + ":" + layerName);
        } else {
            layer = this.getCatalog().getLayerByName(layerName);
        }
        if (layer == null) {
            this.error((Serializable)((Object)new ParamResourceModel("ResourceConfigurationPage.notFound", (Component)this, layerName).getString()));
            this.setResponsePage((IRequestablePage)this.returnPage);
            return;
        }
        this.setupPublished(layer);
        this.setupResource(layer.getResource());
    }

    public ResourceConfigurationPage(ResourceInfo info, boolean isNew) {
        super(isNew);
        this.returnPageClass = LayerPage.class;
        this.setupPublished((LayerInfo)this.getCatalog().getLayers(info).get(0));
        this.setupResource(info);
    }

    @Override
    protected void doSave(boolean doReturn) {
        super.doSave(doReturn);
    }

    public ResourceConfigurationPage(LayerInfo info, boolean isNew) {
        super(info, isNew);
        this.returnPageClass = LayerPage.class;
        this.setupResource(isNew ? info.getResource() : this.getCatalog().getResource(info.getResource().getId(), ResourceInfo.class));
    }

    private void updateResourceInLayerModel(ResourceInfo resource) {
        LayerInfo layer = (LayerInfo)this.getPublishedInfo();
        layer.setResource(resource);
        this.myModel.setObject((Object)layer);
    }

    private void setupResource(ResourceInfo resource) {
        this.updateResourceInLayerModel(resource);
        this.myResourceModel = new CompoundPropertyModel((IModel)new ResourceModel(resource));
    }

    private List<ResourceConfigurationPanelInfo> filterResourcePanels(List<ResourceConfigurationPanelInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).canHandle(this.getResourceInfo())) continue;
            list.remove(i);
            --i;
        }
        return list;
    }

    public ResourceInfo getResourceInfo() {
        return (ResourceInfo)this.myResourceModel.getObject();
    }

    public void updateResource(ResourceInfo info) {
        this.updateResource(info, null);
    }

    public void updateResource(ResourceInfo info, AjaxRequestTarget target) {
        this.myResourceModel.setObject((Object)info);
        this.updateResourceInLayerModel(info);
        this.visitChildren((component, visit) -> {
            if (component instanceof ResourceConfigurationPanel) {
                ResourceConfigurationPanel rcp = (ResourceConfigurationPanel)((Object)component);
                rcp.resourceUpdated(target);
                visit.dontGoDeeper();
            }
        });
    }

    @Override
    protected PublishedEditTabPanel<LayerInfo> createMainTab(String panelID) {
        return new DataLayerEditTabPanel(panelID);
    }

    @Override
    protected void doSaveInternal() throws IOException {
        Catalog catalog = this.getCatalog();
        ResourceInfo resourceInfo = this.getResourceInfo();
        this.validateByChildren(resourceInfo);
        this.visitChildren((component, visit) -> {
            if (component instanceof ResourceConfigurationPanel) {
                ResourceConfigurationPanel rcp = (ResourceConfigurationPanel)((Object)component);
                rcp.onSave();
            }
        });
        this.visitChildren((component, visit) -> {
            if (component instanceof PublishedConfigurationPanel) {
                PublishedConfigurationPanel rcp = (PublishedConfigurationPanel)((Object)component);
                rcp.save();
            }
        });
        if (this.isNew) {
            if (resourceInfo instanceof CoverageInfo) {
                CoverageInfo cinfo = (CoverageInfo)resourceInfo;
                GridCoverage2DReader reader = (GridCoverage2DReader)cinfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
                ReferencedEnvelope bounds = new ReferencedEnvelope((Bounds)reader.getOriginalEnvelope());
                ProjectionPolicy projectionPolicy = resourceInfo.getProjectionPolicy();
                if (projectionPolicy != ProjectionPolicy.NONE && bounds != null) {
                    GridGeometry grid = cinfo.getGrid();
                    cinfo.setGrid((GridGeometry)new GridGeometry2D(grid.getGridRange(), grid.getGridToCRS(), resourceInfo.getCRS()));
                }
            }
            catalog.validate(resourceInfo, true).throwIfInvalid();
            LayerInfo publishedInfo = (LayerInfo)this.getPublishedInfo();
            catalog.add(resourceInfo);
            try {
                catalog.add(publishedInfo);
            }
            catch (Exception e) {
                catalog.remove(resourceInfo);
                throw e;
            }
        }
        ResourceInfo oldState = catalog.getResource(resourceInfo.getId(), ResourceInfo.class);
        catalog.validate(resourceInfo, true).throwIfInvalid();
        LayerInfo publishedInfo = (LayerInfo)this.getPublishedInfo();
        catalog.save(resourceInfo);
        try {
            LayerInfo layer = publishedInfo;
            layer.setResource(resourceInfo);
            catalog.save(layer);
        }
        catch (Exception e) {
            catalog.save(oldState);
            throw e;
        }
    }

    private void validateByChildren(ResourceInfo resourceInfo) {
        if (resourceInfo == null || resourceInfo.getMetadata() == null) {
            return;
        }
        this.visitChildren((component, visitor) -> {
            if (component instanceof MetadataMapValidator) {
                ((MetadataMapValidator)component).validate(resourceInfo.getMetadata());
            }
        });
    }

    protected class DataLayerEditTabPanel
    extends PublishedConfigurationPage.ListEditTabPanel {
        private static final long serialVersionUID = -3442310698941800127L;

        public DataLayerEditTabPanel(String id) {
            super(ResourceConfigurationPage.this, id);
        }

        protected ListView<ResourceConfigurationPanelInfo> createList(String id) {
            List<ResourceConfigurationPanelInfo> dataPanels = ResourceConfigurationPage.this.filterResourcePanels(ResourceConfigurationPage.this.getGeoServerApplication().getBeansOfType(ResourceConfigurationPanelInfo.class));
            ListView<ResourceConfigurationPanelInfo> dataPanelList = new ListView<ResourceConfigurationPanelInfo>(id, dataPanels){
                private static final long serialVersionUID = -845785165778837024L;

                protected void populateItem(ListItem<ResourceConfigurationPanelInfo> item) {
                    ResourceConfigurationPanelInfo panelInfo = (ResourceConfigurationPanelInfo)item.getModelObject();
                    try {
                        Class componentClass = panelInfo.getComponentClass();
                        Constructor constructor = componentClass.getConstructor(String.class, IModel.class);
                        ResourceConfigurationPanel panel = (ResourceConfigurationPanel)((Object)constructor.newInstance("content", ResourceConfigurationPage.this.myResourceModel));
                        item.add(new Component[]{panel});
                    }
                    catch (Exception e) {
                        throw new WicketRuntimeException("Failed to add pluggable resource configuration panels", (Throwable)e);
                    }
                }
            };
            return dataPanelList;
        }
    }
}

