/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layergroup;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.data.layergroup.LayerGroupDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.SimpleAjaxLink;

public abstract class LayerGroupListPanel
extends GeoServerTablePanel<LayerGroupInfo> {
    private static final long serialVersionUID = -4906590200057066912L;
    static GeoServerDataProvider.Property<LayerGroupInfo> NAME = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("name", "name");
    static GeoServerDataProvider.Property<LayerGroupInfo> WORKSPACE = new GeoServerDataProvider.BeanProperty<LayerGroupInfo>("workspace", "workspace.name");

    public LayerGroupListPanel(String id, final WorkspaceInfo workspace) {
        super(id, new GeoServerDataProvider<LayerGroupInfo>(){
            private static final long serialVersionUID = 6471805356307807737L;

            @Override
            protected List<LayerGroupInfo> getItems() {
                if (workspace == null) {
                    return this.getCatalog().getLayerGroups();
                }
                return this.getCatalog().getLayerGroupsByWorkspace(workspace);
            }

            @Override
            protected List<GeoServerDataProvider.Property<LayerGroupInfo>> getProperties() {
                return Arrays.asList(NAME, WORKSPACE);
            }

            @Override
            public IModel<LayerGroupInfo> newModel(LayerGroupInfo object) {
                return new LayerGroupDetachableModel(object);
            }
        });
        this.getTopPager().setVisible(false);
    }

    @Override
    protected Component getComponentForProperty(String id, final IModel<LayerGroupInfo> itemModel, GeoServerDataProvider.Property<LayerGroupInfo> property) {
        IModel<?> model = property.getModel(itemModel);
        if (NAME == property) {
            return new SimpleAjaxLink<String>(id, model){
                private static final long serialVersionUID = -5189072047640596694L;

                @Override
                protected void onClick(AjaxRequestTarget target) {
                    LayerGroupInfo layerGroup = (LayerGroupInfo)itemModel.getObject();
                    LayerGroupListPanel.this.handleLayerGroup(layerGroup, target);
                }
            };
        }
        return new Label(id, model);
    }

    protected void handleLayerGroup(LayerGroupInfo layerGroup, AjaxRequestTarget target) {
    }
}

