/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geoserver.web.data.layer.Parameter;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.jdbc.VirtualTable;
import org.geotools.util.logging.Logging;

public class SQLViewParamProvider
extends GeoServerDataProvider<Parameter> {
    private static final long serialVersionUID = 4823593149295419810L;
    private static final String DEFAULT_REGEXP = "^[\\w\\d\\s]+$";
    static final Logger LOGGER = Logging.getLogger(SQLViewParamProvider.class);
    List<Parameter> parameters = new ArrayList<Parameter>();
    static final GeoServerDataProvider.Property<Parameter> NAME = new GeoServerDataProvider.BeanProperty<Parameter>("name", "name");
    static final GeoServerDataProvider.Property<Parameter> DEFAULT_VALUE = new GeoServerDataProvider.BeanProperty<Parameter>("defaultValue", "defaultValue");
    static final GeoServerDataProvider.Property<Parameter> REGEXP = new GeoServerDataProvider.BeanProperty<Parameter>("regexp", "regexp");

    public SQLViewParamProvider() {
        this.setEditable(true);
    }

    @Override
    protected List<Parameter> getItems() {
        return this.parameters;
    }

    @Override
    protected List<GeoServerDataProvider.Property<Parameter>> getProperties() {
        return Arrays.asList(NAME, DEFAULT_VALUE, REGEXP);
    }

    public void init(VirtualTable vt) {
        this.parameters.clear();
        for (String name : vt.getParameterNames()) {
            this.parameters.add(new Parameter(vt.getParameter(name)));
        }
    }

    public void refreshFromSql(String sql) {
        Pattern p = Pattern.compile("%[\\w\\d\\s]+%");
        Matcher matcher = p.matcher(sql);
        HashSet<String> paramNames = new HashSet<String>();
        while (matcher.find()) {
            paramNames.add(matcher.group().replace('%', ' ').trim());
        }
        this.parameters.clear();
        for (String name : paramNames) {
            this.parameters.add(new Parameter(name, null, DEFAULT_REGEXP));
        }
    }

    public void updateVirtualTable(VirtualTable vt) {
        for (String name : vt.getParameterNames()) {
            vt.removeParameter(name);
        }
        for (Parameter param : this.parameters) {
            vt.addParameter(param.toVirtualTableParameter());
        }
    }

    public void addParameter() {
        this.parameters.add(new Parameter(null, null, DEFAULT_REGEXP));
    }

    public void removeAll(List<Parameter> params) {
        this.parameters.removeAll(params);
    }
}

