/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import org.apache.wicket.Component;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.web.data.layer.LayerPage;
import org.geoserver.web.data.layer.SQLViewAbstractPage;
import org.geoserver.web.data.resource.ResourceConfigurationPage;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.data.FeatureSource;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.VirtualTable;

public class SQLViewNewPage
extends SQLViewAbstractPage {
    private static final long serialVersionUID = 3670565306101168775L;

    public SQLViewNewPage(PageParameters params) throws IOException {
        super(params);
    }

    @Override
    protected void onSave() {
        try {
            VirtualTable vt = this.buildVirtualTable();
            DataStoreInfo dsInfo = (DataStoreInfo)this.getCatalog().getStore(this.storeId, DataStoreInfo.class);
            JDBCDataStore ds = (JDBCDataStore)dsInfo.getDataStore(null);
            ds.createVirtualTable(vt);
            CatalogBuilder builder = new CatalogBuilder(this.getCatalog());
            builder.setStore((StoreInfo)dsInfo);
            FeatureTypeInfo fti = builder.buildFeatureType((FeatureSource)ds.getFeatureSource(vt.getName()));
            fti.getMetadata().put("JDBC_VIRTUAL_TABLE", (Serializable)vt);
            LayerInfo layerInfo = builder.buildLayer(fti);
            this.setResponsePage((IRequestablePage)new ResourceConfigurationPage(layerInfo, true));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to create feature type", e);
            this.error((Serializable)((Object)new ParamResourceModel("creationFailure", (Component)this, this.getFirstErrorMessage(e)).getString()));
        }
    }

    @Override
    protected void onCancel() {
        this.doReturn(LayerPage.class);
    }
}

