/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.layer;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

class AttributeDescription
implements Serializable {
    static final List<Class<?>> BINDINGS = Arrays.asList(String.class, Boolean.class, Integer.class, Long.class, Float.class, Double.class, Date.class, Time.class, Timestamp.class, Geometry.class, Point.class, LineString.class, Polygon.class, MultiPoint.class, MultiLineString.class, MultiPolygon.class, GeometryCollection.class);
    static final CoordinateReferenceSystem WGS84;
    String name;
    Class<?> binding = String.class;
    boolean nullable = true;
    int size = 100;
    CoordinateReferenceSystem crs = WGS84;

    AttributeDescription() {
    }

    static String getLocalizedName(Class<?> binding) {
        if (binding == null) {
            return "-";
        }
        if (BINDINGS.contains(binding)) {
            return new ParamResourceModel("AttributeType." + binding.getSimpleName(), null, new Object[0]).getString();
        }
        return binding.getSimpleName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getBinding() {
        return this.binding;
    }

    public void setBinding(Class<?> binding) {
        this.binding = binding;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    static {
        try {
            WGS84 = CRS.decode((String)"EPSG:4326");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

