/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.admin;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.web.GeoserverAjaxSubmitLink;
import org.geoserver.web.admin.ContactPanel;
import org.geoserver.web.admin.ServerAdminPage;

public class ContactPage
extends ServerAdminPage {
    private final IModel<GeoServer> geoServerModel = this.getGeoServerModel();
    private final IModel<ContactInfo> contactModel = this.getContactInfoModel();

    public ContactPage() {
        Form form = new Form("form", (IModel)new CompoundPropertyModel(this.contactModel));
        this.add(new Component[]{form});
        form.add(new Component[]{new ContactPanel("contact", this.contactModel)});
        form.add(new Component[]{new Button("submit"){

            public void onSubmit() {
                ContactPage.this.save(true);
            }
        }});
        form.add(new Component[]{this.applyLink(form)});
        form.add(new Component[]{new Button("cancel"){

            public void onSubmit() {
                ContactPage.this.doReturn();
            }
        }});
    }

    public void save(boolean doReturn) {
        GeoServer gs = (GeoServer)this.geoServerModel.getObject();
        GeoServerInfo global = gs.getGlobal();
        global.getSettings().setContact((ContactInfo)this.contactModel.getObject());
        gs.save(global);
        if (doReturn) {
            this.doReturn();
        }
    }

    private GeoserverAjaxSubmitLink applyLink(Form<?> form) {
        return new GeoserverAjaxSubmitLink("apply", form, this){

            @Override
            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{this.getForm()});
            }

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target) {
                try {
                    ContactPage.this.save(false);
                }
                catch (IllegalArgumentException e) {
                    this.getForm().error((Serializable)((Object)e.getMessage()));
                    target.add(new Component[]{this.getForm()});
                }
            }
        };
    }
}

