/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentUpdatingBehavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.BoundedCatalogLoader;
import org.geoserver.web.GeoServerHomePage;
import org.geoserver.web.data.layer.PublishedChoiceRenderer;
import org.geoserver.web.data.layer.PublishedInfosModel;
import org.geoserver.web.data.workspace.WorkspaceChoiceNameRenderer;
import org.geoserver.web.data.workspace.WorkspacesModel;
import org.geoserver.web.spring.security.GeoServerSession;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.Select2DropDownChoice;
import org.geotools.api.filter.Filter;
import org.geotools.util.logging.Logging;

abstract class HomePageSelection
implements Serializable {
    static final Logger LOGGER = Logging.getLogger(HomePageSelection.class);
    public static String SELECTION_MODE = "GeoServerHomePage.selectionMode";
    static SelectionMode MODE = SelectionMode.get();
    static long HOME_PAGE_TIMEOUT = Long.getLong("GeoServerHomePage.selectionTimeout", 5000L);
    static int HOME_PAGE_MAX_ITEMS = Integer.getInteger("GeoServerHomePage.selectionMaxItems", 1000);
    protected final GeoServerHomePage page;

    public static HomePageSelection getHomePageSelection(GeoServerHomePage page) {
        if (MODE == SelectionMode.DROPDOWN) {
            return new DropDown(page);
        }
        if (MODE == SelectionMode.TEXT) {
            return new Text(page);
        }
        return new Auto(page);
    }

    HomePageSelection(GeoServerHomePage page) {
        this.page = page;
    }

    abstract String getDescription();

    abstract FormComponent<WorkspaceInfo> getWorkspaceField(Form var1, String var2);

    static FormComponent<WorkspaceInfo> getWorkspaceSelect2Choice(final GeoServerHomePage page, Form form, String componentId) {
        final Select2DropDownChoice component = new Select2DropDownChoice("select", new PropertyModel((Object)page, "workspaceInfo"), new WorkspacesModel(), new WorkspaceChoiceNameRenderer());
        component.add(new Behavior[]{new FormComponentUpdatingBehavior(){

            protected void onUpdate() {
                WorkspaceInfo newSelection = (WorkspaceInfo)component.getModelObject();
                if (newSelection != null) {
                    page.selectHomePage(newSelection.getName(), null);
                } else {
                    String workspaceName = page.getWorkspaceFieldText();
                    page.selectHomePage(workspaceName, null);
                }
            }
        }});
        component.setNullValid(true);
        Fragment fragment = new Fragment(componentId, "select", (MarkupContainer)page);
        fragment.add(new Component[]{component});
        form.add(new Component[]{fragment});
        return component;
    }

    protected TextField<WorkspaceInfo> getWorkspaceTextField(Form form, String componentId) {
        TextField<WorkspaceInfo> component = new TextField<WorkspaceInfo>("text", (IModel)new PropertyModel((Object)this.page, "workspaceInfo")){

            public <C> IConverter<C> getConverter(Class<C> type) {
                if (WorkspaceInfo.class.isAssignableFrom(type)) {
                    return new WorkspaceInfoConverter();
                }
                return null;
            }
        };
        component.setOutputMarkupId(true);
        Fragment fragment = new Fragment(componentId, "text", (MarkupContainer)this.page);
        fragment.add(new Component[]{component});
        form.add(new Component[]{fragment});
        return component;
    }

    abstract FormComponent<PublishedInfo> getPublishedField(Form var1, String var2);

    static Select2DropDownChoice<PublishedInfo> getPublishedSelect2Choice(final GeoServerHomePage page, Form form, String componentId) {
        PublishedInfosModel layersModel = new PublishedInfosModel(){

            @Override
            protected Filter getFilter() {
                return HomePageSelection.getLayerFilter(page, page.getWorkspaceInfo());
            }
        };
        PublishedChoiceRenderer layersRenderer = new PublishedChoiceRenderer(){

            @Override
            public Object getDisplayValue(PublishedInfo layer) {
                return page.getWorkspaceInfo() != null ? layer.getName() : layer.prefixedName();
            }
        };
        final Select2DropDownChoice<PublishedInfo> component = new Select2DropDownChoice<PublishedInfo>("select", (IModel<PublishedInfo>)new PropertyModel((Object)page, "publishedInfo"), (IModel<List<PublishedInfo>>)layersModel, (IChoiceRenderer<PublishedInfo>)layersRenderer);
        component.add(new Behavior[]{new FormComponentUpdatingBehavior(){

            protected void onUpdate() {
                PublishedInfo newSelection = (PublishedInfo)component.getModelObject();
                if (newSelection != null) {
                    String prefixed = newSelection.prefixedName();
                    if (prefixed.contains(":")) {
                        String workspaceName = prefixed.substring(0, prefixed.indexOf(":"));
                        String layerName = prefixed.substring(prefixed.indexOf(":") + 1);
                        page.selectHomePage(workspaceName, layerName);
                    } else {
                        page.selectHomePage(null, prefixed);
                    }
                } else {
                    String workspaceName = page.getWorkspaceFieldText();
                    page.selectHomePage(workspaceName, null);
                }
            }
        }});
        component.setNullValid(true);
        Fragment fragment = new Fragment(componentId, "select", (MarkupContainer)page);
        fragment.add(new Component[]{component});
        form.add(new Component[]{fragment});
        return component;
    }

    protected TextField<PublishedInfo> getPublishedTextField(Form form, String componentId) {
        TextField<PublishedInfo> component = new TextField<PublishedInfo>("text", (IModel)new PropertyModel((Object)this.page, "publishedInfo")){

            public <C> IConverter<C> getConverter(Class<C> type) {
                if (PublishedInfo.class.isAssignableFrom(type)) {
                    return new PublishedInfoConverter();
                }
                return null;
            }
        };
        component.setOutputMarkupId(true);
        Fragment fragment = new Fragment(componentId, "text", (MarkupContainer)this.page);
        fragment.add(new Component[]{component});
        form.add(new Component[]{fragment});
        return component;
    }

    private static Filter getLayerFilter(GeoServerHomePage page, WorkspaceInfo workspace) {
        Filter isLayerInfo = Predicates.isInstanceOf(LayerInfo.class);
        Filter isLayerGroupInfo = Predicates.isInstanceOf(LayerGroupInfo.class);
        Filter enabledFilter = Predicates.equal((String)"resource.enabled", (Object)true);
        Filter storeEnabledFilter = Predicates.equal((String)"resource.store.enabled", (Object)true);
        Filter advertisedFilter = Predicates.equal((String)"resource.advertised", (Object)true);
        Filter enabledLayerGroup = Predicates.equal((String)"enabled", (Object)true);
        Filter advertisedLayerGroup = Predicates.equal((String)"advertised", (Object)true);
        ArrayList<Filter> layerFilters = new ArrayList<Filter>();
        layerFilters.add(isLayerInfo);
        if (workspace != null) {
            layerFilters.add(Predicates.equal((String)"resource.namespace.prefix", (Object)workspace.getName()));
        }
        layerFilters.add(enabledFilter);
        layerFilters.add(storeEnabledFilter);
        layerFilters.add(advertisedFilter);
        Filter layerFilter = Predicates.and(layerFilters);
        ArrayList<Filter> groupFilters = new ArrayList<Filter>();
        groupFilters.add(isLayerGroupInfo);
        if (workspace != null) {
            groupFilters.add(Predicates.equal((String)"workspace.name", (Object)workspace.getName()));
        }
        if (!page.getGeoServer().getGlobal().isGlobalServices().booleanValue()) {
            groupFilters.add(Predicates.not((Filter)Predicates.isNull((String)"workspace.name")));
        }
        groupFilters.add(enabledLayerGroup);
        groupFilters.add(advertisedLayerGroup);
        Filter layerGroupFilter = Predicates.and(groupFilters);
        return Predicates.or((Filter)layerFilter, (Filter)layerGroupFilter);
    }

    protected StringResourceModel getFullDescription(int workspaceCount, int layerCount) {
        Locale locale = this.page.getLocale();
        PublishedInfo publishedInfo = this.page.getPublishedInfo();
        WorkspaceInfo workspaceInfo = this.page.getWorkspaceInfo();
        NumberFormat numberFormat = NumberFormat.getIntegerInstance(locale);
        numberFormat.setGroupingUsed(true);
        String userName = GeoServerSession.get().getUsername();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("workspaceCount", numberFormat.format(workspaceCount));
        params.put("layerCount", numberFormat.format(layerCount));
        params.put("user", this.escapeMarkup(userName));
        boolean isGlobal = this.page.getGeoServer().getGlobal().isGlobalServices();
        if (publishedInfo != null && publishedInfo instanceof LayerInfo) {
            params.put("layerName", this.escapeMarkup(publishedInfo.prefixedName()));
            return new StringResourceModel("GeoServerHomePage.descriptionLayer", (Component)this.page, (IModel)new Model(params));
        }
        if (publishedInfo != null && publishedInfo instanceof LayerGroupInfo) {
            params.put("layerName", this.escapeMarkup(publishedInfo.prefixedName()));
            return new StringResourceModel("GeoServerHomePage.descriptionLayerGroup", (Component)this.page, (IModel)new Model(params));
        }
        if (workspaceInfo != null) {
            params.put("workspaceName", this.escapeMarkup(workspaceInfo.getName()));
            return new StringResourceModel("GeoServerHomePage.descriptionWorkspace", (Component)this.page, (IModel)new Model(params));
        }
        if (isGlobal) {
            return new StringResourceModel("GeoServerHomePage.descriptionGlobal", (Component)this.page, (IModel)new Model(params));
        }
        return new StringResourceModel("GeoServerHomePage.descriptionGlobalOff", (Component)this.page, (IModel)new Model(params));
    }

    private static int countLayerNames(GeoServerHomePage page, WorkspaceInfo workspaceInfo) {
        return page.getCatalog().count(PublishedInfo.class, HomePageSelection.getLayerFilter(page, workspaceInfo));
    }

    private String escapeMarkup(String text) {
        return new StringBuilder(Strings.escapeMarkup((CharSequence)text)).toString();
    }

    private class PublishedInfoConverter
    implements IConverter<PublishedInfo> {
        private PublishedInfoConverter() {
        }

        public PublishedInfo convertToObject(String s, Locale locale) throws ConversionException {
            WorkspaceInfo ws = HomePageSelection.this.page.getWorkspaceInfo();
            if (ws != null) {
                LayerGroupInfo result = HomePageSelection.this.page.getCatalog().getLayerGroupByName(ws, s);
                result = result == null && !s.contains(":") ? HomePageSelection.this.page.getCatalog().getLayerByName(ws.getName() + ":" + s) : HomePageSelection.this.page.getCatalog().getLayerByName(s);
                return result;
            }
            LayerGroupInfo result = HomePageSelection.this.page.getCatalog().getLayerGroupByName(s);
            if (result == null) {
                result = HomePageSelection.this.page.getCatalog().getLayerByName(s);
            }
            return result;
        }

        public String convertToString(PublishedInfo published, Locale locale) {
            if (HomePageSelection.this.page.getWorkspaceInfo() != null) {
                return published.getName();
            }
            return published.prefixedName();
        }
    }

    private class WorkspaceInfoConverter
    implements IConverter<WorkspaceInfo> {
        private WorkspaceInfoConverter() {
        }

        public WorkspaceInfo convertToObject(String s, Locale locale) throws ConversionException {
            return HomePageSelection.this.page.getCatalog().getWorkspaceByName(s);
        }

        public String convertToString(WorkspaceInfo workspaceInfo, Locale locale) {
            return workspaceInfo.getName();
        }
    }

    static class Auto
    extends HomePageSelection {
        private final BoundedCatalogLoader<WorkspaceInfo> workspaceLoader;
        private BoundedCatalogLoader<PublishedInfo> publishedLoader;

        public Auto(GeoServerHomePage page) {
            super(page);
            this.workspaceLoader = new BoundedCatalogLoader<WorkspaceInfo>(page.getCatalog(), Predicates.acceptAll(), WorkspaceInfo.class, HOME_PAGE_TIMEOUT, HOME_PAGE_MAX_ITEMS);
            this.publishedLoader = new BoundedCatalogLoader<PublishedInfo>(page.getCatalog(), HomePageSelection.getLayerFilter(page, page.getWorkspaceInfo()), PublishedInfo.class, this.workspaceLoader.getResidualTime(), HOME_PAGE_MAX_ITEMS);
        }

        @Override
        String getDescription() {
            if (this.workspaceLoader.isBoundExceeded() || this.publishedLoader.isBoundExceeded()) {
                return new ParamResourceModel("GeoServerHomePage.description", (Component)this.page, new Object[0]).getString();
            }
            return this.getFullDescription(this.workspaceLoader.getResult().size(), this.publishedLoader.getResult().size()).getString();
        }

        @Override
        FormComponent<WorkspaceInfo> getWorkspaceField(Form form, String componentId) {
            if (this.workspaceLoader.isBoundExceeded()) {
                return this.getWorkspaceTextField(form, componentId);
            }
            return Auto.getWorkspaceSelect2Choice(this.page, form, componentId);
        }

        @Override
        FormComponent<PublishedInfo> getPublishedField(Form form, String componentId) {
            if (this.publishedLoader.isBoundExceeded()) {
                return this.getPublishedTextField(form, componentId);
            }
            return Auto.getPublishedSelect2Choice(this.page, form, componentId);
        }
    }

    static class Text
    extends HomePageSelection {
        public Text(GeoServerHomePage page) {
            super(page);
        }

        @Override
        String getDescription() {
            return new ParamResourceModel("GeoServerHomePage.description", (Component)this.page, new Object[0]).getString();
        }

        @Override
        FormComponent<WorkspaceInfo> getWorkspaceField(Form form, String componentId) {
            return this.getWorkspaceTextField(form, componentId);
        }

        @Override
        FormComponent<PublishedInfo> getPublishedField(Form form, String componentId) {
            return this.getPublishedTextField(form, componentId);
        }
    }

    static class DropDown
    extends HomePageSelection {
        public DropDown(GeoServerHomePage page) {
            super(page);
        }

        @Override
        String getDescription() {
            int workspaceCount = this.page.getCatalog().count(WorkspaceInfo.class, Predicates.acceptAll());
            int layerCount = HomePageSelection.countLayerNames(this.page, this.page.getWorkspaceInfo());
            return this.getFullDescription(workspaceCount, layerCount).getString();
        }

        @Override
        FormComponent<WorkspaceInfo> getWorkspaceField(Form form, String componentId) {
            return DropDown.getWorkspaceSelect2Choice(this.page, form, componentId);
        }

        @Override
        FormComponent<PublishedInfo> getPublishedField(Form form, String componentId) {
            return DropDown.getPublishedSelect2Choice(this.page, form, componentId);
        }
    }

    static enum SelectionMode {
        AUTOMATIC,
        DROPDOWN,
        TEXT;


        static SelectionMode get() {
            try {
                String mode = GeoServerExtensions.getProperty((String)SELECTION_MODE);
                if (!Strings.isEmpty((String)mode)) {
                    return SelectionMode.valueOf(mode.toUpperCase());
                }
            }
            catch (IllegalArgumentException ignore) {
                LOGGER.fine("Unrecognized GeoServer home page selection mode: " + ignore);
            }
            return AUTOMATIC;
        }
    }
}

