/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.web.GeoServerApplication;

public class DeveloperToolbar
extends Panel {
    private AjaxCheckBox wicketIds;

    public DeveloperToolbar(String id) {
        super(id);
        this.add(new Component[]{new IndicatingAjaxLink<Object>("clearCache"){

            public void onClick(AjaxRequestTarget target) {
                GeoServerApplication.get().clearWicketCaches();
            }
        }});
        this.add(new Component[]{new IndicatingAjaxLink<Object>("reload"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClick(AjaxRequestTarget target) {
                try {
                    GeoServerLoader loader = (GeoServerLoader)GeoServerApplication.get().getBean("geoServerLoader");
                    Object object = GeoServer.CONFIGURATION_LOCK;
                    synchronized (object) {
                        loader.reload();
                    }
                    this.info((Serializable)((Object)"Catalog and configuration reloaded"));
                }
                catch (Exception e) {
                    this.error(e);
                }
            }
        }});
        GeoServerApplicationModel gsApp = new GeoServerApplicationModel();
        final AjaxCheckBox wicketPaths = new AjaxCheckBox("wicketPaths", (IModel)new PropertyModel((Object)gsApp, "debugSettings.componentPathAttributeName")){

            protected void onUpdate(AjaxRequestTarget target) {
            }
        };
        wicketPaths.setOutputMarkupId(true);
        this.add(new Component[]{wicketPaths});
        this.wicketIds = new AjaxCheckBox("wicketIds", (IModel)new PropertyModel((Object)gsApp, "markupSettings.stripWicketTags")){

            protected void onUpdate(AjaxRequestTarget target) {
                wicketPaths.setModelObject((Object)Boolean.FALSE);
                target.add(new Component[]{wicketPaths});
            }
        };
        this.wicketIds.setOutputMarkupId(true);
        this.add(new Component[]{this.wicketIds});
        this.add(new Component[]{new AjaxCheckBox("ajaxDebug", (IModel)new PropertyModel((Object)gsApp, "debugSettings.ajaxDebugModeEnabled")){

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
    }

    static class GeoServerApplicationModel
    extends LoadableDetachableModel<GeoServerApplication> {
        GeoServerApplicationModel() {
            super((Object)GeoServerApplication.get());
        }

        protected GeoServerApplication load() {
            return GeoServerApplication.get();
        }
    }
}

