/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.geoserver.GeoServerNodeData;
import org.geoserver.web.GeoServerNodeInfo;
import org.geoserver.web.spring.security.GeoServerSession;

public class DefaultGeoServerNodeInfo
implements GeoServerNodeInfo,
Serializable {
    private static final long serialVersionUID = -8731277645321595181L;
    static final String GEOSERVER_NODE_OPTS = "GEOSERVER_NODE_OPTS";
    static GeoServerNodeData NODE_DATA = null;

    @Override
    public GeoServerNodeData getData() {
        return NODE_DATA;
    }

    @Override
    public void customize(WebMarkupContainer container) {
        container.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"default-node-info"))});
        final Map properties = NODE_DATA.getIdStyle();
        if (properties != null && !properties.isEmpty()) {
            container.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = -7945010069411202354L;

                public void renderHead(Component component, IHeaderResponse response) {
                    String script = DefaultGeoServerNodeInfo.toJavaScript(properties);
                    response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)script));
                }
            }});
        }
        container.setVisible(this.isNodeIdVisible(container));
    }

    private static String toJavaScript(Map<String, String> properties) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            builder.append("document.getElementsByClassName('default-node-info')[0].style.");
            builder.append(StringEscapeUtils.escapeEcmaScript((String)entry.getKey()));
            builder.append(" = '");
            builder.append(StringEscapeUtils.escapeEcmaScript((String)entry.getValue()));
            builder.append("';\n");
        }
        return builder.toString().trim();
    }

    protected static void initializeFromEnviroment() {
        NODE_DATA = GeoServerNodeData.createFromEnvironment();
    }

    protected boolean isNodeIdVisible(WebMarkupContainer parent) {
        if (NODE_DATA.getId() == null) {
            return false;
        }
        return ((GeoServerSession)parent.getSession()).isAdmin();
    }

    static {
        DefaultGeoServerNodeInfo.initializeFromEnviroment();
    }
}

