/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import org.geoserver.web.wicket.SRSProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class SRSIdentifierComparatorTest {
    static final SRSProvider.SRSIdentifierComparator COMPARATOR = new SRSProvider.SRSIdentifierComparator();
    private static final Matcher<Integer> LOWER = Matchers.lessThan((Comparable)Integer.valueOf(0));
    private static final Matcher<Integer> EQUAL = Matchers.equalTo((Object)0);
    private static final Matcher<Integer> HIGHER = Matchers.greaterThan((Comparable)Integer.valueOf(0));

    @Test
    public void testEPSGCommon() {
        SRSIdentifierComparatorTest.assertComparison("EPSG:4326", "EPSG:4326", EQUAL);
        SRSIdentifierComparatorTest.assertComparison("EPSG:4326", "EPSG:4327", LOWER);
        SRSIdentifierComparatorTest.assertComparison("EPSG:4327", "EPSG:4326", HIGHER);
    }

    private static void assertComparison(String id1, String id2, Matcher<Integer> equal) {
        MatcherAssert.assertThat((Object)COMPARATOR.compare(new SRSProvider.SRS(id1), new SRSProvider.SRS(id2)), equal);
    }

    @Test
    public void testCrossAuthority() {
        SRSIdentifierComparatorTest.assertComparison("EPSG:4326", "IAU:4326", LOWER);
        SRSIdentifierComparatorTest.assertComparison("IAU:4326", "EPSG:4326", HIGHER);
    }

    @Test
    public void testNoAuthority() {
        SRSIdentifierComparatorTest.assertComparison("EPSG:4326", "TEST", HIGHER);
        SRSIdentifierComparatorTest.assertComparison("TEST", "EPSG:4326", LOWER);
    }
}

