/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.system.status;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.util.tester.TagTester;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.admin.StatusPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SystemStatusMonitorPanelTest
extends GeoServerWicketTestSupport {
    @Before
    public void setupTests() {
        this.login();
        tester.getApplication().getMarkupSettings().setStripWicketTags(false);
        tester.startPage(StatusPage.class);
    }

    @Test
    public void testLoad() throws Exception {
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:2:link", true);
        tester.assertContains("CPUs");
    }

    @Test
    public void testUpdate() throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        tester.assertRenderedPage(StatusPage.class);
        tester.clickLink("tabs:tabs-container:tabs:2:link", true);
        TagTester time1 = tester.getTagByWicketId("time");
        Assert.assertNotNull((Object)time1);
        Date firstTime = formatter.parse(time1.getValue());
        Thread.sleep(1000L);
        tester.executeAllTimerBehaviors((MarkupContainer)tester.getLastRenderedPage());
        TagTester time2 = tester.getTagByWicketId("time");
        Assert.assertNotNull((Object)time2);
        Date secondTime = formatter.parse(time2.getValue());
        Assert.assertTrue((secondTime.getTime() > firstTime.getTime() ? 1 : 0) != 0);
        Thread.sleep(1000L);
        tester.executeAllTimerBehaviors((MarkupContainer)tester.getLastRenderedPage());
        TagTester time3 = tester.getTagByWicketId("time");
        Assert.assertNotNull((Object)time3);
        Date thirdTime = formatter.parse(time3.getValue());
        Assert.assertTrue((thirdTime.getTime() > secondTime.getTime() ? 1 : 0) != 0);
    }
}

