/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.publish;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.feedback.ErrorLevelFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.publish.RootLayerConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RootLayerConfigTest
extends GeoServerWicketTestSupport {
    LayerInfo polygons;
    FormTestPage page;

    @Before
    public void init() {
        this.polygons = this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart());
        this.page = new FormTestPage(id -> new RootLayerConfig(id, (IModel)new Model((Serializable)this.polygons)));
        tester.startPage((Page)this.page);
    }

    @Test
    public void testRootLayerRemoveWMSGlobal() {
        tester.assertRenderedPage(FormTestPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:rootLayer", 0);
        ft.submit();
        Assert.assertEquals((long)0L, (long)this.page.getSession().getFeedbackMessages().messages((IFeedbackMessageFilter)new ErrorLevelFeedbackMessageFilter(400)).size());
        Assert.assertNull((Object)this.polygons.getMetadata().get("rootInCapabilities", Boolean.class));
    }

    @Test
    public void testRootLayerRemoveYes() {
        tester.assertRenderedPage(FormTestPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:rootLayer", 1);
        ft.submit();
        Assert.assertEquals((long)0L, (long)this.page.getSession().getFeedbackMessages().messages((IFeedbackMessageFilter)new ErrorLevelFeedbackMessageFilter(400)).size());
        Assert.assertTrue((boolean)((Boolean)this.polygons.getMetadata().get("rootInCapabilities", Boolean.class)));
    }

    @Test
    public void testRootLayerRemoveNo() {
        tester.assertRenderedPage(FormTestPage.class);
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:rootLayer", 2);
        ft.submit();
        Assert.assertEquals((long)0L, (long)this.page.getSession().getFeedbackMessages().messages((IFeedbackMessageFilter)new ErrorLevelFeedbackMessageFilter(400)).size());
        Assert.assertFalse((boolean)((Boolean)this.polygons.getMetadata().get("rootInCapabilities", Boolean.class)));
    }
}

