/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.geoserver.security.impl.FileSandboxEnforcer;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.layer.NewLayerPage;
import org.geoserver.web.data.store.CoverageStoreEditPage;
import org.geoserver.web.data.store.CoverageStoreNewPage;
import org.geoserver.web.data.store.panel.FileParamPanel;
import org.geoserver.web.data.store.panel.WorkspacePanel;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.geotiff.GeoTiffFormatFactorySpi;
import org.geotools.geopkg.mosaic.GeoPackageFormat;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class CoverageStoreNewPageTest
extends GeoServerWicketTestSupport {
    private static final boolean debugMode = false;
    String formatType;
    String formatDescription;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.setUpDefaultRasterLayers();
        GeoServerExtensions.bean(FileSandboxEnforcer.class, (ApplicationContext)applicationContext);
    }

    @Before
    public void init() {
        AbstractGridFormat format = new GeoTiffFormatFactorySpi().createFormat();
        this.formatType = format.getName();
        this.formatDescription = format.getDescription();
    }

    private CoverageStoreNewPage startPage() {
        this.login();
        CoverageStoreNewPage page = new CoverageStoreNewPage(this.formatType);
        tester.startPage((Page)page);
        return page;
    }

    @Test
    public void testInitCreateNewCoverageStoreInvalidDataStoreFactoryName() {
        String formatName = "_invalid_";
        try {
            this.login();
            new CoverageStoreNewPage("_invalid_");
            Assert.fail((String)"Expected IAE on invalid format name");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith("Can't obtain the factory"));
        }
    }

    @Test
    public void testPageRendersOnLoad() {
        this.startPage();
        tester.assertLabel("rasterStoreForm:storeType", this.formatType);
        tester.assertLabel("rasterStoreForm:storeTypeDescription", this.formatDescription);
        tester.assertComponent("rasterStoreForm:workspacePanel", WorkspacePanel.class);
    }

    @Test
    public void testInitialModelState() {
        CoverageStoreNewPage page = this.startPage();
        Assert.assertNull((Object)page.getDefaultModelObject());
        tester.assertModelValue("rasterStoreForm:enabledPanel:paramValue", (Object)Boolean.TRUE);
        tester.assertModelValue("rasterStoreForm:workspacePanel:border:border_body:paramValue", (Object)this.getCatalog().getDefaultWorkspace());
        tester.assertModelValue("rasterStoreForm:parametersPanel:url", (Object)"file:data/example.extension");
    }

    @Test
    public void testMultipleResources() {
        CoverageStoreNewPage page = this.startPage();
        Assert.assertNull((Object)page.getDefaultModelObject());
        tester.assertModelValue("rasterStoreForm:enabledPanel:paramValue", (Object)Boolean.TRUE);
        tester.assertModelValue("rasterStoreForm:workspacePanel:border:border_body:paramValue", (Object)this.getCatalog().getDefaultWorkspace());
        tester.assertModelValue("rasterStoreForm:parametersPanel:url", (Object)"file:data/example.extension");
    }

    @Test
    public void testGeoPackageRaster() {
        this.login();
        this.formatType = new GeoPackageFormat().getName();
        CoverageStoreNewPage page = new CoverageStoreNewPage(this.formatType);
        tester.startPage((Page)page);
        tester.debugComponentTrees();
        Component urlComponent = tester.getComponentFromLastRenderedPage("rasterStoreForm:parametersPanel:url");
        MatcherAssert.assertThat((Object)urlComponent, (Matcher)CoreMatchers.instanceOf(FileParamPanel.class));
    }

    @Test
    public void testNewCoverageSave() {
        this.startPage();
        FormTester ft = tester.newFormTester("rasterStoreForm");
        ft.setValue("parametersPanel:url:fileInput:border:border_body:paramValue", "BlueMarble/tazbm.tiff");
        ft.setValue("namePanel:border:border_body:paramValue", "tazbm2");
        ft.submit("save");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(NewLayerPage.class);
        CoverageStoreInfo store = this.getCatalog().getCoverageStoreByName("tazbm2");
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((Object)"BlueMarble/tazbm.tiff", (Object)store.getURL());
    }

    @Test
    public void testNewCoverageApply() {
        this.startPage();
        FormTester ft = tester.newFormTester("rasterStoreForm");
        ft.setValue("parametersPanel:url:fileInput:border:border_body:paramValue", "BlueMarble/tazbm.tiff");
        ft.setValue("namePanel:border:border_body:paramValue", "tazbm3");
        ft.submit("apply");
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(CoverageStoreEditPage.class);
        CoverageStoreInfo store = this.getCatalog().getCoverageStoreByName("tazbm3");
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((Object)"BlueMarble/tazbm.tiff", (Object)store.getURL());
    }

    @Test
    public void testDisableOnConnFailureCheckbox() {
        this.startPage();
        FormTester ft = tester.newFormTester("rasterStoreForm");
        ft.setValue("parametersPanel:url:fileInput:border:border_body:paramValue", "BlueMarble/tazbm.tiff");
        ft.setValue("namePanel:border:border_body:paramValue", "tazbm99");
        Component component = tester.getComponentFromLastRenderedPage("rasterStoreForm:disableOnConnFailurePanel:paramValue");
        CheckBox checkBox = (CheckBox)component;
        Assert.assertFalse((boolean)Boolean.valueOf(checkBox.getInput()));
        ft.setValue("disableOnConnFailurePanel:paramValue", true);
        ft.submit("save");
        tester.assertNoErrorMessage();
        CoverageStoreInfo store = this.getCatalog().getCoverageStoreByName("tazbm99");
        Assert.assertNotNull((Object)store);
        Assert.assertTrue((boolean)store.isDisableOnConnFailure());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNewCoverageSandbox() throws Exception {
        File systemSandbox = new File("./target/systemSandbox").getCanonicalFile();
        System.setProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX, systemSandbox.getAbsolutePath());
        File testDir = new File("./target/test").getCanonicalFile();
        testDir.mkdirs();
        File bmFolder = new File(systemSandbox, "bm");
        bmFolder.mkdirs();
        ((DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class)).reload();
        String fileName = "tazbm.tiff";
        File tazbmInside = new File(bmFolder, fileName);
        File tazbmOutside = new File(testDir, fileName);
        try (InputStream is = MockData.class.getResourceAsStream(fileName);){
            FileUtils.copyToFile((InputStream)is, (File)tazbmInside);
        }
        is = MockData.class.getResourceAsStream(fileName);
        try {
            FileUtils.copyToFile((InputStream)is, (File)tazbmOutside);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        try {
            this.startPage();
            FormTester ft = tester.newFormTester("rasterStoreForm");
            ft.setValue("parametersPanel:url:fileInput:border:border_body:paramValue", tazbmOutside.getAbsolutePath());
            ft.setValue("namePanel:border:border_body:paramValue", "tazbm4");
            ft.submit("apply");
            List messages = tester.getMessages(400);
            Assert.assertEquals((long)1L, (long)messages.size());
            CoverageStoreNewPageTest.checkSandboxDeniedMessage(((Serializable)messages.get(0)).toString(), tazbmOutside);
            CoverageStoreNewPageTest.checkSandboxDeniedMessage(tester.getLastResponseAsString(), tazbmOutside);
            tester.clearFeedbackMessages();
            ft.setValue("parametersPanel:url:fileInput:border:border_body:paramValue", tazbmInside.getAbsolutePath());
            ft.submit("apply");
            tester.assertNoErrorMessage();
            tester.assertRenderedPage(CoverageStoreEditPage.class);
            CoverageStoreInfo store = this.getCatalog().getCoverageStoreByName("tazbm4");
            Assert.assertNotNull((Object)store);
            Assert.assertEquals((Object)("file://" + tazbmInside.getAbsolutePath().replace("\\", "/")), (Object)store.getURL());
        }
        finally {
            System.clearProperty(DefaultFileAccessManager.GEOSERVER_DATA_SANDBOX);
            ((DefaultFileAccessManager)GeoServerExtensions.bean(DefaultFileAccessManager.class)).reload();
        }
    }

    private static void checkSandboxDeniedMessage(String message, File tazbmOutside) {
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Access to "), (Matcher)Matchers.containsString((String)tazbmOutside.getAbsolutePath()), (Matcher)Matchers.containsString((String)" denied by file sandboxing")));
    }
}

