/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.resource;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.data.resource.MetadataLinkEditor;
import org.junit.Assert;
import org.junit.Test;

public class MetadataLinkEditorTest
extends GeoServerWicketTestSupport {
    private static final String METADATA_TYPE = "FGDC";
    private static final String ABOUT = "http://www.geoserver.org/about";
    private static final String FORMAT = "text/xml";
    private static final String METADATA_LINK = "http://www.geoserver.org/meta";

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(CiteTestData.ROAD_SEGMENTS, this.getCatalog());
    }

    @Test
    public void testEditLinks() throws Exception {
        FeatureTypeInfo featureType = this.getCatalog().getFeatureTypeByName(this.getLayerId(CiteTestData.ROAD_SEGMENTS));
        Assert.assertEquals((long)0L, (long)featureType.getMetadataLinks().size());
        tester.startPage((Page)new FormTestPage(id -> new MetadataLinkEditor(id, (IModel)new Model((Serializable)featureType))));
        tester.executeAjaxEvent("form:panel:addlink", "click");
        this.print((Component)tester.getLastRenderedPage(), true, true, true);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("panel:container:table:links:0:type", METADATA_TYPE);
        ft.setValue("panel:container:table:links:0:about", ABOUT);
        ft.setValue("panel:container:table:links:0:format", FORMAT);
        ft.setValue("panel:container:table:links:0:urlBorder:urlBorder_body:metadataLinkURL", METADATA_LINK);
        ft.submit();
        List links = featureType.getMetadataLinks();
        Assert.assertEquals((long)1L, (long)links.size());
        MetadataLinkInfo link = (MetadataLinkInfo)links.get(0);
        Assert.assertEquals((Object)METADATA_TYPE, (Object)link.getMetadataType());
        Assert.assertEquals((Object)ABOUT, (Object)link.getAbout());
        Assert.assertEquals((Object)FORMAT, (Object)link.getType());
        Assert.assertEquals((Object)METADATA_LINK, (Object)link.getContent());
    }
}

